/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.vfs;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.SchemaProvider;
import org.tinygroup.vfs.impl.FileSchemaProvider;
import org.tinygroup.vfs.impl.FtpSchemaProvider;
import org.tinygroup.vfs.impl.HttpSchemaProvider;
import org.tinygroup.vfs.impl.HttpsSchemaProvider;
import org.tinygroup.vfs.impl.JBossVfsSchemaProvider;
import org.tinygroup.vfs.impl.JarSchemaProvider;
import org.tinygroup.vfs.impl.WsJarSchemaProvider;
import org.tinygroup.vfs.impl.ZipSchemaProvider;

public final class VFS {
    private static Map<String, FileObject> fileObjectCacheMap = new ConcurrentHashMap<String, FileObject>();
    private static Map<String, Long> fileModifyTimeMap = new ConcurrentHashMap<String, Long>();
    private static Map<String, SchemaProvider> schemaProviderMap = new HashMap<String, SchemaProvider>();
    private static String defaultSchema = "file:";

    private VFS() {
    }

    public static void clearCache() {
        fileObjectCacheMap.clear();
    }

    public static void addSchemaProvider(SchemaProvider schemaProvider) {
        schemaProviderMap.put(schemaProvider.getSchema(), schemaProvider);
    }

    public static void setDefaultSchemaProvider(String schema) {
        defaultSchema = schema;
    }

    public static SchemaProvider getSchemaProvider(String schema) {
        return schemaProviderMap.get(schema);
    }

    public static FileObject resolveFile(String resourceResolve) {
        long newTime;
        long oldTime;
        String resource = resourceResolve;
        FileObject fileObject = fileObjectCacheMap.get(resource);
        if (fileObject != null && fileObject.isInPackage() && (oldTime = fileModifyTimeMap.get(resource).longValue()) == (newTime = fileObject.getLastModifiedTime())) {
            return fileObject;
        }
        try {
            resource = URLDecoder.decode(resource, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        SchemaProvider schemaProvider = schemaProviderMap.get(defaultSchema);
        for (SchemaProvider provider : schemaProviderMap.values()) {
            if (!provider.isMatch(resource)) continue;
            schemaProvider = provider;
            break;
        }
        if ((fileObject = schemaProvider.resolver(resource)) != null && fileObject.isInPackage()) {
            fileObjectCacheMap.put(resource, fileObject);
            fileModifyTimeMap.put(resource, fileObject.getLastModifiedTime());
        }
        return fileObject;
    }

    public static FileObject resolveURL(URL url) {
        return VFS.resolveFile(url.getPath());
    }

    static {
        VFS.addSchemaProvider(new JarSchemaProvider());
        VFS.addSchemaProvider(new WsJarSchemaProvider());
        VFS.addSchemaProvider(new ZipSchemaProvider());
        VFS.addSchemaProvider(new FileSchemaProvider());
        VFS.addSchemaProvider(new HttpSchemaProvider());
        VFS.addSchemaProvider(new HttpsSchemaProvider());
        VFS.addSchemaProvider(new JBossVfsSchemaProvider());
        VFS.addSchemaProvider(new FtpSchemaProvider());
    }
}

