/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.threadgroup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.threadgroup.Processor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiThreadProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiThreadProcessor.class);
    private CountDownLatch downLatch = null;
    private List<Processor> processors = new ArrayList<Processor>();
    private String name;

    public MultiThreadProcessor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addProcessor(Processor[] processors) {
        for (Processor processor : processors) {
            this.addProcessor(processor);
        }
    }

    public void addProcessor(Processor processor) {
        this.processors.add(processor);
        processor.setMultiThreadProcess(this);
    }

    public void addProcessor(Collection<Processor> processorCollection) {
        for (Processor processor : processorCollection) {
            this.addProcessor(processor);
        }
    }

    public void threadDone() {
        this.downLatch.countDown();
    }

    public void start() {
        this.downLatch = new CountDownLatch(this.processors.size());
        LOGGER.logMessage(LogLevel.DEBUG, "\u7ebf\u7a0b\u7ec4<{}>\u8fd0\u884c\u5f00\u59cb,\u7ebf\u7a0b\u6570{}...", new Object[]{this.name, this.processors.size()});
        long start = System.currentTimeMillis();
        for (Processor processor : this.processors) {
            Thread thread = new Thread(processor);
            thread.setName(this.name + "-" + processor.getName());
            thread.start();
        }
        try {
            this.downLatch.await();
        }
        catch (InterruptedException e) {
            LOGGER.errorMessage("\u7f13\u7a0b\u7ec4<{}\u8fd0\u884c\u51fa\u73b0\u95ee\u9898\uff1a{}>", (Throwable)e, new Object[]{this.name, e.getMessage()});
        }
        long end = System.currentTimeMillis();
        LOGGER.logMessage(LogLevel.DEBUG, "\u7ebf\u7a0b\u7ec4<{}>\u8fd0\u884c\u7ed3\u675f, \u7528\u65f6:{}ms", new Object[]{this.name, end - start});
    }
}

