/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.rumtime;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.template.rumtime.ForStatus;

public final class ForIterator
implements Iterator,
ForStatus {
    private Iterator iterator = null;
    private int index = 0;
    private int size = 0;

    public void setIndex(int index) {
        this.index = index;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public ForIterator() {
    }

    public ForIterator(Object object) {
        if (null != object) {
            if (object.getClass().isArray()) {
                this.iterator = new ArrayIterator(object);
                this.size = ArrayUtil.arrayLength((Object)object);
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                this.iterator = collection.iterator();
                this.size = collection.size();
            } else if (object instanceof Iterator) {
                this.iterator = (Iterator)object;
                this.size = -1;
            } else if (object instanceof Map) {
                Map map = (Map)object;
                this.iterator = map.entrySet().iterator();
                this.size = map.size();
            } else if (object instanceof Enumeration) {
                Enumeration enumeration = (Enumeration)object;
                ArrayList list = Collections.list(enumeration);
                this.iterator = list.iterator();
                this.size = list.size();
            } else if (object.getClass().isEnum()) {
                List itemList = Arrays.asList(((Class)object).getEnumConstants());
                this.iterator = itemList.iterator();
                this.size = itemList.size();
            } else {
                this.iterator = new SingletonIterator(object);
                this.size = 1;
            }
        }
    }

    public boolean hasNext() {
        if (this.iterator == null) {
            return false;
        }
        return this.iterator.hasNext();
    }

    public Object next() {
        ++this.index;
        return this.iterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getIndex() {
        return this.index;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isFirst() {
        return this.index == 1;
    }

    public boolean isLast() {
        return !this.iterator.hasNext();
    }

    public boolean isOdd() {
        return (this.index & 1) != 0;
    }

    public boolean isEven() {
        return (this.index & 1) == 0;
    }

    static class ArrayIterator
    implements Iterator {
        private final Object object;
        private int size = 0;
        private int index = 0;

        public ArrayIterator(Object object) {
            this.object = object;
            this.size = ArrayUtil.arrayLength((Object)object);
        }

        public boolean hasNext() {
            return this.index < this.size;
        }

        public Object next() {
            return Array.get(this.object, this.index++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class SingletonIterator
    implements Iterator {
        private Object object;

        public SingletonIterator(Object object) {
            this.object = object;
        }

        public boolean hasNext() {
            return this.object != null;
        }

        public Object next() {
            Object result = this.object;
            this.object = null;
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

