/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.loader;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.tinygroup.commons.file.IOUtils;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.impl.TemplateEngineDefault;
import org.tinygroup.template.loader.AbstractResourceLoader;
import org.tinygroup.template.loader.TemplateLoadUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileObjectResourceLoader
extends AbstractResourceLoader<FileObject> {
    private FileObject root = null;
    private Map<String, FileObject> caches = new HashMap<String, FileObject>();

    public FileObject getRootFileObject() {
        return this.root;
    }

    public FileObjectResourceLoader(String templateExtName, String layoutExtName, String macroLibraryExtName, String root) {
        this(templateExtName, layoutExtName, macroLibraryExtName, VFS.resolveFile((String)root));
    }

    public FileObjectResourceLoader(String templateExtName, String layoutExtName, String macroLibraryExtName, FileObject root) {
        super(templateExtName, layoutExtName, macroLibraryExtName);
        this.root = root;
    }

    @Override
    public Template createTemplate(FileObject fileObject) throws TemplateException {
        if (fileObject != null) {
            this.caches.put(fileObject.getPath(), fileObject);
            return this.loadTemplate(fileObject);
        }
        return null;
    }

    @Override
    protected Template loadTemplateItem(String path) throws TemplateException {
        return this.createTemplate(this.root.getFileObject(path));
    }

    @Override
    public boolean isModified(String path) {
        FileObject fileObject = this.caches.get(path);
        if (fileObject == null) {
            fileObject = this.getFileObject(path);
        }
        if (fileObject == null) {
            return true;
        }
        return fileObject.isModified();
    }

    @Override
    public void resetModified(String path) {
        FileObject fileObject = this.getFileObject(path);
        if (fileObject != null) {
            fileObject.resetModified();
        }
    }

    private FileObject getFileObject(String path) {
        return this.root.getFileObject(path);
    }

    @Override
    public String getResourceContent(String path, String encode) throws TemplateException {
        FileObject fileObject = this.root.getFileObject(path);
        if (fileObject != null) {
            try {
                return IOUtils.readFromInputStream((InputStream)fileObject.getInputStream(), (String)encode);
            }
            catch (Exception e) {
                throw new TemplateException(e);
            }
        }
        return null;
    }

    private Template loadTemplate(FileObject fileObject) throws TemplateException {
        try {
            Template templateFromContext = TemplateLoadUtil.loadComponent((TemplateEngineDefault)this.getTemplateEngine(), fileObject.getPath(), this.getResourceContent(fileObject.getPath(), this.getTemplateEngine().getEncode()));
            this.addTemplate(templateFromContext);
            return templateFromContext;
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
    }
}

