/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.loader;

import org.tinygroup.template.ResourceLoader;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.TemplateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceLoader<T>
implements ResourceLoader<T> {
    private ClassLoader classLoader;
    private TemplateEngine templateEngine;
    private String templateExtName;
    private String layoutExtName;
    private String macroLibraryExtName;

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public AbstractResourceLoader(String templateExtName, String layoutExtName, String macroLibraryExtName) {
        this.templateExtName = "." + templateExtName;
        this.layoutExtName = "." + layoutExtName;
        this.macroLibraryExtName = "." + macroLibraryExtName;
        this.setClassLoader(this.getClass().getClassLoader());
    }

    @Override
    public String getLayoutPath(String templatePath) {
        if (templatePath.endsWith(this.templateExtName)) {
            return templatePath.substring(0, templatePath.length() - this.templateExtName.length()) + this.layoutExtName;
        }
        return null;
    }

    @Override
    public String getTemplateExtName() {
        return this.templateExtName;
    }

    @Override
    public String getLayoutExtName() {
        return this.layoutExtName;
    }

    public String getMacroLibraryExtName() {
        return this.macroLibraryExtName;
    }

    public void setMacroLibraryExtName(String macroLibraryExtName) {
        this.macroLibraryExtName = macroLibraryExtName;
    }

    @Override
    public Template getTemplate(String path) throws TemplateException {
        return this.getTemplateItem(path, this.templateExtName);
    }

    private Template getTemplateItem(String path, String templateExtName) throws TemplateException {
        if (!path.endsWith(templateExtName)) {
            return null;
        }
        Template template = this.getTemplateEngine().getRepositories().get(path);
        if ((template == null || this.isModified(path)) && (template = this.loadTemplateItem(path)) != null) {
            this.resetModified(path);
        }
        return template;
    }

    @Override
    public boolean isModified(String path) {
        return false;
    }

    @Override
    public void resetModified(String path) {
    }

    @Override
    public Template getLayout(String path) throws TemplateException {
        return this.getTemplateItem(path, this.layoutExtName);
    }

    @Override
    public Template getMacroLibrary(String path) throws TemplateException {
        return this.getTemplateItem(path, this.macroLibraryExtName);
    }

    protected abstract Template loadTemplateItem(String var1) throws TemplateException;

    @Override
    public ResourceLoader addTemplate(Template template) throws TemplateException {
        return this.addTemplateItem(template);
    }

    private ResourceLoader addTemplateItem(Template template) {
        if (!this.getTemplateEngine().isCheckModified()) {
            this.getTemplateEngine().getRepositories().put(template.getPath(), template);
        }
        template.setTemplateEngine(this.templateEngine);
        template.getTemplateContext().setParent(this.templateEngine.getTemplateContext());
        return this;
    }

    @Override
    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    @Override
    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }
}

