/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.interpret;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.impl.TemplateEngineDefault;
import org.tinygroup.template.interpret.ContextProcessor;
import org.tinygroup.template.interpret.MacroException;
import org.tinygroup.template.interpret.ReturnException;
import org.tinygroup.template.interpret.StopException;
import org.tinygroup.template.interpret.TemplateFromContext;
import org.tinygroup.template.interpret.TerminalNodeProcessor;
import org.tinygroup.template.interpret.terminal.OtherTerminalNodeProcessor;
import org.tinygroup.template.listener.TinyTemplateErrorListener;
import org.tinygroup.template.parser.grammer.TinyTemplateLexer;
import org.tinygroup.template.parser.grammer.TinyTemplateParser;

public class TemplateInterpreter {
    TerminalNodeProcessor[] terminalNodeProcessors = new TerminalNodeProcessor[200];
    Map<Class<ParserRuleContext>, ContextProcessor> contextProcessorMap = new HashMap<Class<ParserRuleContext>, ContextProcessor>();
    OtherTerminalNodeProcessor otherNodeProcessor = new OtherTerminalNodeProcessor();

    public OtherTerminalNodeProcessor getOtherNodeProcessor() {
        return this.otherNodeProcessor;
    }

    public void setOtherNodeProcessor(OtherTerminalNodeProcessor otherNodeProcessor) {
        this.otherNodeProcessor = otherNodeProcessor;
    }

    public void addTerminalNodeProcessor(TerminalNodeProcessor processor) {
        this.terminalNodeProcessors[processor.getType()] = processor;
    }

    public void addContextProcessor(ContextProcessor contextProcessor) {
        this.contextProcessorMap.put(contextProcessor.getType(), contextProcessor);
    }

    public TinyTemplateParser.TemplateContext parserTemplateTree(String sourceName, String templateString) throws TemplateException {
        char[] source = templateString.toCharArray();
        ANTLRInputStream is = new ANTLRInputStream(source, source.length);
        is.name = sourceName;
        TinyTemplateParser parser = new TinyTemplateParser((TokenStream)new CommonTokenStream((TokenSource)new TinyTemplateLexer((CharStream)is)));
        TinyTemplateErrorListener listener = new TinyTemplateErrorListener(sourceName);
        parser.addErrorListener(listener);
        TinyTemplateParser.TemplateContext context = parser.template();
        if (listener.getTemplateException().size() > 0) {
            throw listener.getTemplateException().get(0);
        }
        return context;
    }

    public void interpret(TemplateEngineDefault engine, TemplateFromContext templateFromContext, String templateString, String sourceName, TemplateContext pageContext, TemplateContext context, OutputStream outputStream, String fileName) throws Exception {
        this.interpret(engine, templateFromContext, this.parserTemplateTree(sourceName, templateString), pageContext, context, outputStream, fileName);
    }

    public void interpret(TemplateEngineDefault engine, TemplateFromContext templateFromContext, TinyTemplateParser.TemplateContext templateParseTree, TemplateContext pageContext, TemplateContext context, OutputStream outputStream, String fileName) throws Exception {
        for (int i = 0; i < templateParseTree.getChildCount(); ++i) {
            this.interpretTree(engine, templateFromContext, templateParseTree.getChild(i), pageContext, context, outputStream, fileName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object interpretTree(TemplateEngineDefault engine, TemplateFromContext templateFromContext, ParseTree tree, TemplateContext pageContext, TemplateContext context, OutputStream outputStream, String fileName) throws Exception {
        Object returnValue = null;
        if (tree instanceof TerminalNode) {
            TerminalNode terminalNode = (TerminalNode)tree;
            TerminalNodeProcessor processor = this.terminalNodeProcessors[terminalNode.getSymbol().getType()];
            if (processor == null) return this.otherNodeProcessor.process(terminalNode, context, outputStream, templateFromContext);
            return processor.process(terminalNode, context, outputStream, templateFromContext);
        }
        if (tree instanceof ParserRuleContext) {
            try {
                ContextProcessor processor = this.contextProcessorMap.get(tree.getClass());
                if (processor != null) {
                    returnValue = processor.process(this, templateFromContext, (ParserRuleContext)tree, pageContext, context, engine, outputStream, fileName);
                }
                if (processor != null) return returnValue;
                for (int i = 0; i < tree.getChildCount(); ++i) {
                    Object value = this.interpretTree(engine, templateFromContext, tree.getChild(i), pageContext, context, outputStream, fileName);
                    if (value == null) continue;
                    returnValue = value;
                }
                return returnValue;
            }
            catch (StopException se) {
                throw se;
            }
            catch (ReturnException se) {
                throw se;
            }
            catch (MacroException me) {
                ParserRuleContext parserRuleContext = (ParserRuleContext)tree;
                if (!this.checkMacroContext(me, tree)) throw me;
                me.setContext(parserRuleContext, null);
                throw me;
            }
            catch (TemplateException te) {
                if (te.getContext() != null) throw te;
                te.setContext((ParserRuleContext)tree, fileName);
                throw te;
            }
            catch (Exception e) {
                throw new TemplateException(e, (ParserRuleContext)tree, fileName);
            }
        } else {
            for (int i = 0; i < tree.getChildCount(); ++i) {
                Object value = this.interpretTree(engine, templateFromContext, tree.getChild(i), pageContext, context, outputStream, fileName);
                if (returnValue != null || value == null) continue;
                returnValue = value;
            }
        }
        return returnValue;
    }

    private boolean checkMacroContext(MacroException me, ParseTree tree) {
        if (me.getContext() != null) {
            return false;
        }
        return tree.getClass() == TinyTemplateParser.Call_macro_block_directiveContext.class || tree.getClass() == TinyTemplateParser.BlockContext.class;
    }
}

