/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.interpret;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.impl.AbstractTemplate;
import org.tinygroup.template.impl.TemplateEngineDefault;
import org.tinygroup.template.interpret.MacroException;
import org.tinygroup.template.interpret.ReturnException;
import org.tinygroup.template.interpret.StopException;
import org.tinygroup.template.parser.grammer.TinyTemplateParser;
import org.tinygroup.template.rumtime.TemplateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateFromContext
extends AbstractTemplate {
    Map<ParseTree, byte[]> terminalNodeMap = new ConcurrentHashMap<ParseTree, byte[]>();
    Map<ParseTree, Object> objectMap = new ConcurrentHashMap<ParseTree, Object>();
    private String path;
    TinyTemplateParser.TemplateContext templateContext;
    private static String[] stripWithSpaceChars = new String[]{" ", "    "};

    public String getText(ParseTree parseTree) {
        String result = (String)this.objectMap.get(parseTree);
        if (result == null) {
            result = parseTree.getText();
            this.objectMap.put(parseTree, result);
        }
        return result;
    }

    public void putObject(ParseTree parseTree, Object object) {
        this.objectMap.put(parseTree, object);
    }

    public <T> T getObject(ParseTree parseTree) {
        return (T)this.objectMap.get(parseTree);
    }

    public byte[] getTerminalNodeBytes(TerminalNode terminalNode, TemplateFromContext templateFromContext, int left, int right) throws TemplateException {
        byte[] bytes = this.terminalNodeMap.get(terminalNode);
        if (bytes == null) {
            try {
                String text = terminalNode.getText();
                if (left > 0 || right > 0) {
                    text = text.substring(left, text.length() - right);
                }
                text = this.getTemplateEngine().isCompactMode() ? this.trimCommentsDirectiveWhileSpaceNewLine(text, terminalNode, true) : this.trimCommentsDirectiveWhileSpaceNewLine(text, terminalNode, false);
                bytes = text.getBytes(this.getTemplateEngine().getEncode());
                this.terminalNodeMap.put((ParseTree)terminalNode, bytes);
            }
            catch (UnsupportedEncodingException e) {
                throw new TemplateException(e);
            }
        }
        return bytes;
    }

    private String trimCommentsDirectiveWhileSpaceNewLine(String text, TerminalNode nowTerminalNode, boolean trimWhileSpace) {
        if (text == null || text.length() == 0) {
            return "";
        }
        if (nowTerminalNode.getParent() instanceof TinyTemplateParser.TextContext) {
            TinyTemplateParser.TextContext parseTree = (TinyTemplateParser.TextContext)nowTerminalNode.getParent();
            ParserRuleContext parentParserRuleContext = this.getParseTrreeParentButBlock(parseTree);
            if (this.isDirectiveNeedTrim((ParseTree)parentParserRuleContext)) {
                text = this.trimTextLeft(text);
                if (trimWhileSpace) {
                    text = TemplateUtil.trimStart(text, stripWithSpaceChars);
                    text = TemplateUtil.trimEnd(text, stripWithSpaceChars);
                }
            } else if (parentParserRuleContext instanceof TinyTemplateParser.BlockContext) {
                ParseTree previousParseContext;
                int parentChildrenIndex = this.getParentChildrenIndex(parseTree, parentParserRuleContext);
                if (parentChildrenIndex > 0 && ((previousParseContext = parentParserRuleContext.getChild(parentChildrenIndex - 1)) instanceof TinyTemplateParser.CommentContext || previousParseContext instanceof TinyTemplateParser.DirectiveContext && (previousParseContext.getChild(0) instanceof TinyTemplateParser.Set_directiveContext || previousParseContext.getChild(0) instanceof TinyTemplateParser.Blank_directiveContext || previousParseContext.getChild(0) instanceof TinyTemplateParser.Call_macro_directiveContext || previousParseContext.getChild(0) instanceof TinyTemplateParser.Call_macro_block_directiveContext || previousParseContext.getChild(0) instanceof TinyTemplateParser.Import_directiveContext || previousParseContext.getChild(0) instanceof TinyTemplateParser.If_directiveContext))) {
                    text = this.trimTextLeft(text);
                    if (trimWhileSpace) {
                        text = TemplateUtil.trimStart(text, stripWithSpaceChars);
                    }
                }
                if (trimWhileSpace && parentChildrenIndex < parentParserRuleContext.getChildCount() && ((previousParseContext = parentParserRuleContext.getChild(parentChildrenIndex + 1)) instanceof TinyTemplateParser.CommentContext || previousParseContext instanceof TinyTemplateParser.DirectiveContext && (previousParseContext.getChild(0) instanceof TinyTemplateParser.Set_directiveContext || previousParseContext.getChild(0) instanceof TinyTemplateParser.Blank_directiveContext || previousParseContext.getChild(0) instanceof TinyTemplateParser.Call_macro_directiveContext || previousParseContext.getChild(0) instanceof TinyTemplateParser.Call_macro_block_directiveContext || previousParseContext.getChild(0) instanceof TinyTemplateParser.Import_directiveContext || previousParseContext.getChild(0) instanceof TinyTemplateParser.If_directiveContext))) {
                    text = TemplateUtil.trimEnd(text, stripWithSpaceChars);
                }
            }
        }
        return text;
    }

    private String trimTextLeft(String text) {
        int len = text.length();
        int leftPos = 0;
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t') continue;
            if (c == '\r') {
                int n = i + 1;
                if (n < len && text.charAt(n) == '\n') {
                    leftPos = n + 1;
                    break;
                }
                leftPos = n;
                break;
            }
            if (c != '\n') break;
            leftPos = i + 1;
            break;
        }
        if (leftPos > 0) {
            text = text.equals("\r\n") ? "" : text.substring(leftPos, len);
        }
        return text;
    }

    private ParserRuleContext getParseTrreeParentButBlock(ParserRuleContext parseTree) {
        ParserRuleContext parentParserRuleContext = parseTree.getParent();
        if (parentParserRuleContext instanceof TinyTemplateParser.TemplateContext) {
            return parentParserRuleContext;
        }
        if (parentParserRuleContext instanceof TinyTemplateParser.BlockContext) {
            if (parentParserRuleContext.getParent() instanceof TinyTemplateParser.TemplateContext) {
                return parentParserRuleContext;
            }
            if (parentParserRuleContext.getParent() instanceof TinyTemplateParser.BlockContext) {
                return this.getParseTrreeParentButBlock(parentParserRuleContext.getParent());
            }
            return parentParserRuleContext.getParent();
        }
        return parentParserRuleContext;
    }

    private int getParentChildrenIndex(ParserRuleContext parseTree, ParserRuleContext parserRuleContext) {
        int parentChildrenIndex = 0;
        for (int i = 0; i < parserRuleContext.getChildCount(); ++i) {
            ParserRuleContext childrenTree = (ParserRuleContext)parserRuleContext.getChild(i);
            if (childrenTree != parseTree) continue;
            parentChildrenIndex = i;
            break;
        }
        return parentChildrenIndex;
    }

    public boolean isDirectiveNeedTrim(ParseTree parseTree) {
        return parseTree instanceof TinyTemplateParser.ValueContext || parseTree instanceof TinyTemplateParser.If_directiveContext || parseTree instanceof TinyTemplateParser.For_directiveContext || parseTree instanceof TinyTemplateParser.Else_directiveContext || parseTree instanceof TinyTemplateParser.Call_directiveContext || parseTree instanceof TinyTemplateParser.While_directiveContext || parseTree instanceof TinyTemplateParser.Break_directiveContext || parseTree instanceof TinyTemplateParser.Elseif_directiveContext || parseTree instanceof TinyTemplateParser.Return_directiveContext || parseTree instanceof TinyTemplateParser.Continue_directiveContext || parseTree instanceof TinyTemplateParser.Endofline_directiveContext || parseTree instanceof TinyTemplateParser.Call_macro_block_directiveContext || parseTree instanceof TinyTemplateParser.Macro_directiveContext || parseTree instanceof TinyTemplateParser.Call_block_directiveContext || parseTree instanceof TinyTemplateParser.Layout_impl_directiveContext;
    }

    public TemplateFromContext(String path, TinyTemplateParser.TemplateContext templateContext) {
        this.path = path;
        this.templateContext = templateContext;
    }

    @Override
    protected void renderContent(TemplateContext context, OutputStream outputStream) throws IOException, TemplateException {
        try {
            TemplateEngineDefault templateEngine = (TemplateEngineDefault)this.getTemplateEngine();
            TemplateEngineDefault.interpreter.interpret(templateEngine, this, this.templateContext, context, context, outputStream, this.path);
        }
        catch (StopException e) {
        }
        catch (ReturnException e) {
        }
        catch (MacroException e) {
            throw e;
        }
        catch (TemplateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

