/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.tinygroup.beancontainer.BeanContainer;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.TemplateRender;
import org.tinygroup.template.loader.StringResourceLoader;

public class TemplateRenderDefault
implements TemplateRender {
    private TemplateEngine templateEngine;
    private BeanContainer<?> beanContainer;
    private StringResourceLoader contentLoader = new StringResourceLoader();
    private boolean initResourceLoader = false;

    private void initResourceLoader() {
        if (!this.initResourceLoader) {
            this.initResourceLoader = true;
            this.getTemplateEngine().addResourceLoader(this.contentLoader);
        }
    }

    public TemplateRenderDefault() {
        this.beanContainer = BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader());
    }

    public void setTemplateEngine(TemplateEngine engine) {
        this.templateEngine = engine;
    }

    public TemplateEngine getTemplateEngine() {
        if (this.templateEngine == null) {
            return (TemplateEngine)this.beanContainer.getBean("templateEngine");
        }
        return this.templateEngine;
    }

    public void renderTemplate(String path, TemplateContext context, OutputStream outputStream) throws TemplateException {
        this.getTemplateEngine().renderTemplate(path, context, outputStream);
    }

    public String renderTemplate(String path, TemplateContext context) throws TemplateException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.renderTemplate(path, context, outputStream);
            String string = new String(outputStream.toByteArray(), "UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new TemplateException(e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new TemplateException(e);
            }
        }
    }

    public void renderTemplateWithOutLayout(String path, TemplateContext context, OutputStream outputStream) throws TemplateException {
        this.getTemplateEngine().renderTemplateWithOutLayout(path, context, outputStream);
    }

    public String renderTemplateWithOutLayout(String path, TemplateContext context) throws TemplateException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.renderTemplateWithOutLayout(path, context, outputStream);
            String string = new String(outputStream.toByteArray(), "UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new TemplateException(e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new TemplateException(e);
            }
        }
    }

    public void renderTemplateContent(String content, TemplateContext context, OutputStream outputStream) throws TemplateException {
        this.initResourceLoader();
        Template template = this.contentLoader.loadTemplate(content);
        this.getTemplateEngine().renderTemplate(template, context, outputStream);
    }

    public String renderTemplateContent(String content, TemplateContext context) throws TemplateException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.renderTemplateContent(content, context, outputStream);
            String string = new String(outputStream.toByteArray(), "UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new TemplateException(e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new TemplateException(e);
            }
        }
    }
}

