/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.template.Macro;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.impl.EvaluateExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMacro
implements Macro {
    private Macro bodyContentMacro;
    private String name;
    private List<String> parameterNames = new ArrayList<String>();
    private List<EvaluateExpression> parameterDefaultValues = new ArrayList<EvaluateExpression>();
    private TemplateEngine templateEngine;
    private String macroPath;

    public AbstractMacro(String name) {
        this.name = name;
    }

    public AbstractMacro(String name, Macro bodyContentMacro) {
        this.name = name;
        this.bodyContentMacro = bodyContentMacro;
    }

    protected Macro getMacro(TemplateContext $context) {
        Macro $macro = this.getBodyContentMacro();
        if ($macro == null) {
            $macro = (Macro)$context.getItemMap().get("bodyContent");
        }
        if ($macro == null) {
            TemplateContext context = $context;
            while (context.getParent() != null) {
                if (context.get("bodyContent") != null && context.getItemMap().size() > 0 && !context.getItemMap().containsKey("isCalled")) {
                    $macro = (Macro)context.getItemMap().get("bodyContent");
                    return $macro;
                }
                context = context.getParent();
            }
        }
        return $macro;
    }

    public Macro getBodyContentMacro() {
        return this.bodyContentMacro;
    }

    public AbstractMacro(String name, List<String> parameterNames, List<EvaluateExpression> parameterDefaultValues) {
        this(name);
        this.parameterNames = parameterNames;
        this.parameterDefaultValues = parameterDefaultValues;
    }

    protected void addParameter(String parameterName, EvaluateExpression defaultValue) {
        this.parameterNames.add(parameterName);
        this.parameterDefaultValues.add(defaultValue);
    }

    @Override
    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    @Override
    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public void setParameterNames(List<String> parameterNames) {
        this.parameterNames = parameterNames;
    }

    @Override
    public List<EvaluateExpression> getParameterDefaultValues() {
        return this.parameterDefaultValues;
    }

    public void setParameterDefaultValues(List<EvaluateExpression> parameterDefaultValues) {
        this.parameterDefaultValues = parameterDefaultValues;
    }

    protected void init(String name) {
        this.name = name;
    }

    @Override
    public void render(Template template, TemplateContext pageContext, TemplateContext context, OutputStream outputStream) throws TemplateException {
        try {
            for (int i = 0; i < this.parameterNames.size(); ++i) {
                Object value = context.get(this.parameterNames.get(i));
                if (value != null || this.parameterDefaultValues.get(i) == null) continue;
                context.put(this.parameterNames.get(i), this.parameterDefaultValues.get(i).evaluate(context));
            }
            this.renderMacro(template, pageContext, context, outputStream);
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    protected abstract void renderMacro(Template var1, TemplateContext var2, TemplateContext var3, OutputStream var4) throws IOException, TemplateException;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    @Override
    public String getParameterName(int index) {
        if (index < this.parameterNames.size()) {
            return this.parameterNames.get(index);
        }
        return null;
    }

    @Override
    public String getMacroPath() {
        return this.macroPath;
    }

    @Override
    public void setMacroPath(String macroPath) {
        this.macroPath = macroPath;
    }
}

