/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.fileresolver;

import java.util.List;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.loader.FileObjectResourceLoader;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xmlparser.node.XmlNode;

public class TinyMacroFileProcessor
extends AbstractFileProcessor {
    private static final String COMPONENT_FILE_NAME = ".component";
    private static final String TINY_TEMPLATE_CONFIG = "/application/template-config";
    private static final String TINY_TEMPLATE_CONFIG_PATH = "/templateconfig.config.xml";
    private static final String TEMPLATE_EXT_FILE_NAME = "templateExtFileName";
    private static final String LAYOUT_EXT_FILE_NAME = "layoutExtFileName";
    private static final String COMPONENT_EXT_FILE_NAME = "componentExtFileName";
    private static final String TEMPLATE_EXT_DEFALUT = "page";
    private static final String LAYOUT_EXT_DEFALUT = "layout";
    private static final String COMPONENT_EXT_DEFALUT = "component";
    private TemplateEngine engine;
    private static boolean hasResourceLoader = false;

    public TemplateEngine getEngine() {
        return this.engine;
    }

    public void setEngine(TemplateEngine engine) {
        this.engine = engine;
    }

    public boolean checkMatch(FileObject fileObject) {
        return !fileObject.isFolder() && fileObject.getFileName().endsWith(COMPONENT_FILE_NAME);
    }

    public void process() {
        if (!hasResourceLoader) {
            this.reloadTemplateConfig();
            hasResourceLoader = true;
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6a21\u677f\u914d\u7f6e\u6587\u4ef6[{0}]\u5f00\u59cb\u52a0\u8f7d", new Object[]{fileObject.getAbsolutePath()});
            try {
                this.engine.registerMacroLibrary(fileObject.getPath());
            }
            catch (TemplateException e) {
                LOGGER.errorMessage("\u52a0\u8f7d\u6a21\u677f\u914d\u7f6e\u6587\u4ef6[{0}]\u51fa\u9519", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
            }
            LOGGER.logMessage(LogLevel.INFO, "\u6a21\u677f\u914d\u7f6e\u6587\u4ef6[{0}]\u52a0\u8f7d\u5b8c\u6bd5", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    private void reloadTemplateConfig() {
        XmlNode totalConfig = ConfigurationUtil.combineXmlNode((XmlNode)this.applicationConfig, (XmlNode)this.componentConfig);
        String templateExtFileName = TEMPLATE_EXT_DEFALUT;
        String layoutExtFileName = LAYOUT_EXT_DEFALUT;
        String componentExtFileName = COMPONENT_EXT_DEFALUT;
        if (totalConfig != null) {
            templateExtFileName = StringUtil.defaultIfBlank((String)totalConfig.getAttribute(TEMPLATE_EXT_FILE_NAME), (String)TEMPLATE_EXT_DEFALUT);
            layoutExtFileName = StringUtil.defaultIfBlank((String)totalConfig.getAttribute(LAYOUT_EXT_FILE_NAME), (String)LAYOUT_EXT_DEFALUT);
            componentExtFileName = StringUtil.defaultIfBlank((String)totalConfig.getAttribute(COMPONENT_EXT_FILE_NAME), (String)COMPONENT_EXT_DEFALUT);
        }
        List scanningPaths = this.fileResolver.getScanningPaths();
        for (String path : scanningPaths) {
            FileObjectResourceLoader fileResourceLoader = new FileObjectResourceLoader(templateExtFileName, layoutExtFileName, componentExtFileName, path);
            this.engine.addResourceLoader(fileResourceLoader);
        }
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        super.config(applicationConfig, componentConfig);
    }

    public String getComponentConfigPath() {
        return TINY_TEMPLATE_CONFIG_PATH;
    }

    public String getApplicationNodePath() {
        return TINY_TEMPLATE_CONFIG;
    }
}

