/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.executor;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.impl.TemplateContextDefault;
import org.tinygroup.template.impl.TemplateEngineDefault;
import org.tinygroup.template.loader.FileObjectResourceLoader;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.FileObjectFilter;
import org.tinygroup.vfs.FileObjectProcessor;
import org.tinygroup.vfs.VFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyTemplateExecutor {
    private static final String DEFAULT_TEMPLATE_EXT_NAME = "page";
    private static final String DEFAULT_LAYOUT_EXT_NAME = "layout";
    private static final String DEFAULT_COMPONENT_EXT_NAME = "component";
    private static final String SPLIT_TAG = ";";
    protected static final Logger LOGGER = LoggerFactory.getLogger(TinyTemplateExecutor.class);

    public static void main(String[] args) throws TemplateException {
        if (args.length == 0) {
            System.out.println("Usage:\n\tTinyTemplateExecutor templateFile [relativePath] [absolutePath] [resources] [urlParameters]");
            return;
        }
        String relativePath = null;
        String absolutePath = null;
        String resources = null;
        String urlParameters = null;
        if (args.length >= 1) {
            relativePath = args[0].replaceAll("\\\\", "/");
        }
        if (args.length >= 2) {
            absolutePath = args[1].replaceAll("\\\\", "/");
        }
        if (args.length >= 3) {
            resources = args[2].replaceAll("\\\\", "/");
        }
        if (args.length >= 4) {
            urlParameters = args[3];
        }
        Map<String, String> maps = TinyTemplateExecutor.parserStringParameter(urlParameters);
        String pagedir = TinyTemplateExecutor.getDir(relativePath, absolutePath);
        String root = TinyTemplateExecutor.getProjectRoot(pagedir);
        String templateExtFileName = StringUtil.defaultIfEmpty((String)TinyTemplateExecutor.getExtFileName(relativePath), (String)DEFAULT_TEMPLATE_EXT_NAME);
        String layoutExtFileName = DEFAULT_LAYOUT_EXT_NAME;
        String componentExtFileName = DEFAULT_COMPONENT_EXT_NAME;
        TemplateEngineDefault engine = new TemplateEngineDefault();
        FileObjectResourceLoader resourceLoader = new FileObjectResourceLoader(templateExtFileName, DEFAULT_LAYOUT_EXT_NAME, DEFAULT_COMPONENT_EXT_NAME, root);
        engine.addResourceLoader(resourceLoader);
        if (resources != null) {
            String[] ss;
            for (String resource : ss = resources.split(SPLIT_TAG)) {
                TinyTemplateExecutor.resolveFile(engine, resource, templateExtFileName, DEFAULT_LAYOUT_EXT_NAME, DEFAULT_COMPONENT_EXT_NAME);
            }
        }
        TemplateContextDefault context = new TemplateContextDefault();
        if (!CollectionUtil.isEmpty(maps)) {
            for (Map.Entry<String, String> entry : maps.entrySet()) {
                context.put(entry.getKey(), entry.getValue());
            }
        }
        if (relativePath != null) {
            String prefix = pagedir.substring(root.length(), pagedir.length());
            engine.renderTemplate(prefix + relativePath, (TemplateContext)context, (OutputStream)System.out);
        }
    }

    protected static void resolveFile(final TemplateEngine engine, String root, String templateExtFileName, String layoutExtFileName, final String componentExtFileName) {
        FileObject project = VFS.resolveFile((String)root);
        FileObjectResourceLoader resourceLoader = new FileObjectResourceLoader(templateExtFileName, layoutExtFileName, componentExtFileName, root);
        engine.addResourceLoader(resourceLoader);
        project.foreach(new FileObjectFilter(){

            public boolean accept(FileObject fileObject) {
                return fileObject.getFileName().endsWith("." + componentExtFileName);
            }
        }, new FileObjectProcessor(){

            public void process(FileObject fileObject) {
                try {
                    engine.registerMacroLibrary(fileObject.getPath());
                }
                catch (Exception e) {
                    LOGGER.errorMessage(String.format("load %s error: %s", fileObject.getFileName(), e.getMessage()), (Throwable)e);
                }
            }
        });
    }

    protected static Map<String, String> parserStringParameter(String urlParams) {
        HashMap<String, String> maps = new HashMap<String, String>();
        if (!StringUtil.isBlank((String)urlParams)) {
            String[] ss;
            for (String pair : ss = urlParams.split("&")) {
                int n = pair.indexOf("=");
                if (n == -1) continue;
                maps.put(pair.substring(0, n), pair.substring(n + 1, pair.length()));
            }
        }
        return maps;
    }

    protected static String getJarFileName(FileObject fileObject) {
        if (fileObject != null) {
            String path = fileObject.getAbsolutePath();
            int n = path.lastIndexOf("!");
            if (n != -1) {
                return path.substring(0, n);
            }
            return path;
        }
        return null;
    }

    protected static String getDir(String relativePath, String absolutePath) {
        if (relativePath == null || absolutePath == null) {
            return null;
        }
        return absolutePath.substring(0, absolutePath.length() - relativePath.length());
    }

    protected static String getProjectRoot(String dir) {
        if (dir == null) {
            return null;
        }
        int n = dir.indexOf("src");
        if (n != -1) {
            return dir.substring(0, n);
        }
        return dir;
    }

    protected static String getExtFileName(String path) {
        if (path == null) {
            return null;
        }
        int lastIndexOfDot = path.lastIndexOf(".");
        if (lastIndexOfDot == -1) {
            return null;
        }
        return path.substring(lastIndexOfDot + 1);
    }
}

