/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.application;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.MethodUtils;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.template.application.AbstractStaticClassOperator;
import org.tinygroup.xmlparser.node.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlNodeStaticClassOperator
extends AbstractStaticClassOperator {
    private static final String STATIC_METHOD = "static-method";
    private Map<String, MethodConfig> nameMaps = new ConcurrentHashMap<String, MethodConfig>();
    private Map<String, List<MethodConfig>> methodNameMaps = new ConcurrentHashMap<String, List<MethodConfig>>();

    public XmlNodeStaticClassOperator(XmlNode clazzNode) throws Exception {
        this.setName(clazzNode.getAttribute("name"));
        this.setStaticClass(this.loadClass(clazzNode.getAttribute("class")));
        List staticMethods = clazzNode.getSubNodes(STATIC_METHOD);
        if (staticMethods != null) {
            for (XmlNode methodNode : staticMethods) {
                MethodConfig config = new MethodConfig(methodNode);
                if (!StringUtil.isEmpty((String)config.getName())) {
                    this.addMethodConfigByName(config);
                }
                if (StringUtil.isEmpty((String)config.getMethodName())) continue;
                this.addMethodConfigByMethodName(config);
            }
        }
    }

    private void addMethodConfigByName(MethodConfig config) {
        this.nameMaps.put(config.getName(), config);
    }

    private void addMethodConfigByMethodName(MethodConfig config) {
        List<MethodConfig> methodList = this.methodNameMaps.get(config.getMethodName());
        if (methodList == null) {
            methodList = new ArrayList<MethodConfig>();
            this.methodNameMaps.put(config.getMethodName(), methodList);
        }
        methodList.add(config);
    }

    private Class<?> loadClass(String className) throws Exception {
        return this.getClass().getClassLoader().loadClass(className);
    }

    private MethodConfig findMethodConfig(String name, Object[] args) {
        if (this.nameMaps.containsKey(name)) {
            return this.nameMaps.get(name);
        }
        List<MethodConfig> methods = this.methodNameMaps.get(name);
        if (methods != null) {
            for (MethodConfig config : methods) {
                if (!this.isMatch(args, config.getParameterTypes())) continue;
                return config;
            }
        }
        return null;
    }

    private boolean isMatch(Object[] args, Class[] parameterTypes) {
        if (args == null || parameterTypes == null) {
            return args == null && parameterTypes == null;
        }
        if (args.length != parameterTypes.length) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null && !args[i].getClass().equals(parameterTypes[i])) continue;
            ++count;
        }
        return parameterTypes.length == count;
    }

    @Override
    public Object invokeStaticMethod(String methodName, Object[] args) throws Exception {
        MethodConfig config = this.findMethodConfig(methodName, args);
        if (config != null) {
            return MethodUtils.invokeStaticMethod(this.getStaticClass(), (String)config.getMethodName(), (Object[])args, (Class[])config.getParameterTypes());
        }
        return MethodUtils.invokeStaticMethod(this.getStaticClass(), (String)methodName, (Object[])args);
    }

    class MethodConfig {
        String name;
        String methodName;
        Class[] parameterTypes;

        public MethodConfig(XmlNode methodNode) throws Exception {
            this.name = methodNode.getAttribute("name");
            this.methodName = methodNode.getAttribute("method-name");
            String parameterType = methodNode.getAttribute("parameter-type");
            if (!StringUtil.isEmpty((String)parameterType)) {
                String[] classes = parameterType.split(",");
                this.parameterTypes = new Class[classes.length];
                for (int i = 0; i < classes.length; ++i) {
                    this.parameterTypes[i] = XmlNodeStaticClassOperator.this.loadClass(classes[i]);
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class[] getParameterTypes() {
            return this.parameterTypes;
        }
    }
}

