/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.application;

import java.util.List;
import org.tinygroup.application.AbstractApplicationProcessor;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.template.I18nVisitor;
import org.tinygroup.template.ResourceLoader;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.TemplateFunction;
import org.tinygroup.template.application.XmlNodeStaticClassOperator;
import org.tinygroup.xmlparser.node.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyTemplateConfigProcessor
extends AbstractApplicationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyTemplateConfigProcessor.class);
    private static final String RESOURCE_CONFIG_NAME = "resource-loader";
    private static final String INIT_PARAM_NAME = "init-param";
    private static final String I18N_VISITOR_NAME = "i18n-visitor";
    private static final String TEMPLATE_FUNCTION_NAME = "template-function";
    private static final String STATIC_CLASS_NAME = "static-class";
    private XmlNode applicationConfig;
    private XmlNode componentConfig;
    private TemplateEngine templateEngine;

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public void start() {
        LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u52a0\u8f7dTiny\u6a21\u677f\u5f15\u64ce\u57fa\u672c\u914d\u7f6e");
        XmlNode totalConfig = ConfigurationUtil.combineXmlNode((XmlNode)this.applicationConfig, (XmlNode)this.componentConfig);
        this.configEngineProperties(totalConfig);
        this.configI18nVisitor(totalConfig);
        this.addResourceLoaders(totalConfig);
        this.addFunction(totalConfig);
        this.addStaticClass(totalConfig);
        LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dTiny\u6a21\u677f\u5f15\u64ce\u57fa\u672c\u914d\u7f6e\u7ed3\u675f");
    }

    private void configEngineProperties(XmlNode totalConfig) {
        List list;
        String debug_mode = ConfigurationUtil.getConfigurationManager().getConfiguration("DEBUG_MODE");
        if (!StringUtil.isBlank((String)debug_mode)) {
            this.templateEngine.setCheckModified(Boolean.parseBoolean(debug_mode));
            LOGGER.logMessage(LogLevel.INFO, "\u6839\u636eDEBUG_MODE\u8bbe\u7f6e\u6a21\u677f\u5f15\u64ce\u53c2\u6570checkModified={0}", new Object[]{this.templateEngine.isCheckModified()});
        }
        if ((list = totalConfig.getSubNodes(INIT_PARAM_NAME)) != null) {
            for (XmlNode node : list) {
                try {
                    String name = node.getAttribute("name");
                    String value = node.getAttribute("value");
                    if ("encode".equalsIgnoreCase(name)) {
                        this.templateEngine.setEncode(StringUtil.defaultIfBlank((String)value, (String)"UTF-8"));
                        LOGGER.logMessage(LogLevel.INFO, "\u8bbe\u7f6e\u6a21\u677f\u5f15\u64ce\u53c2\u6570encode={0}", new Object[]{this.templateEngine.getEncode()});
                        continue;
                    }
                    if ("safeVariable".equalsIgnoreCase(name)) {
                        this.templateEngine.setSafeVariable(Boolean.parseBoolean(StringUtil.defaultIfBlank((String)value, (String)"false")));
                        LOGGER.logMessage(LogLevel.INFO, "\u8bbe\u7f6e\u6a21\u677f\u5f15\u64ce\u53c2\u6570safeVariable={0}", new Object[]{this.templateEngine.isSafeVariable()});
                        continue;
                    }
                    if ("compactMode".equalsIgnoreCase(name)) {
                        this.templateEngine.setCompactMode(Boolean.parseBoolean(StringUtil.defaultIfBlank((String)value, (String)"false")));
                        LOGGER.logMessage(LogLevel.INFO, "\u8bbe\u7f6e\u6a21\u677f\u5f15\u64ce\u53c2\u6570compactMode={0}", new Object[]{this.templateEngine.isCompactMode()});
                        continue;
                    }
                    if ("checkModified".equalsIgnoreCase(name)) {
                        this.templateEngine.setCheckModified(Boolean.parseBoolean(StringUtil.defaultIfBlank((String)value, (String)"false")));
                        LOGGER.logMessage(LogLevel.INFO, "\u8bbe\u7f6e\u6a21\u677f\u5f15\u64ce\u53c2\u6570checkModified={0}", new Object[]{this.templateEngine.isCheckModified()});
                        continue;
                    }
                    if (!"localeTemplateEnable".equalsIgnoreCase(name)) continue;
                    this.templateEngine.setLocaleTemplateEnable(Boolean.parseBoolean(StringUtil.defaultIfBlank((String)value, (String)"false")));
                    LOGGER.logMessage(LogLevel.INFO, "\u8bbe\u7f6e\u6a21\u677f\u5f15\u64ce\u53c2\u6570localeTemplateEnable={0}", new Object[]{this.templateEngine.isLocaleTemplateEnable()});
                }
                catch (Exception e) {
                    LOGGER.errorMessage("\u8bbe\u7f6e\u6a21\u677f\u5f15\u64ce\u5c5e\u6027[{0}]\u51fa\u9519,\u5c5e\u6027\u503c[{1}]", (Throwable)e, new Object[]{node.getAttribute("name"), node.getAttribute("value")});
                }
            }
        }
    }

    private void addFunction(XmlNode totalConfig) {
        List list = totalConfig.getSubNodes(TEMPLATE_FUNCTION_NAME);
        if (list != null) {
            for (XmlNode node : list) {
                try {
                    TemplateFunction function = this.createFunction(node);
                    this.templateEngine.addTemplateFunction(function);
                }
                catch (Exception e) {
                    LOGGER.errorMessage("\u52a0\u8f7d\u6a21\u677f\u5f15\u64ce\u7684\u51fd\u6570\u51fa\u9519", (Throwable)e);
                }
            }
        }
    }

    private void addStaticClass(XmlNode totalConfig) {
        List list = totalConfig.getSubNodes(STATIC_CLASS_NAME);
        if (list != null) {
            for (XmlNode node : list) {
                try {
                    this.templateEngine.registerStaticClassOperator(new XmlNodeStaticClassOperator(node));
                }
                catch (Exception e) {
                    LOGGER.errorMessage("\u52a0\u8f7d\u7528\u6237\u6ce8\u518c\u7684\u9759\u6001\u7c7b\u51fa\u9519", (Throwable)e);
                }
            }
        }
    }

    private void configI18nVisitor(XmlNode totalConfig) {
        XmlNode node = (XmlNode)totalConfig.getSubNode(I18N_VISITOR_NAME);
        try {
            I18nVisitor i18n = this.createI18nVisitor(node);
            this.templateEngine.setI18nVisitor(i18n);
        }
        catch (Exception e) {
            LOGGER.errorMessage("\u52a0\u8f7d\u6a21\u677f\u5f15\u64ce\u7684\u56fd\u9645\u5316\u8d44\u6e90\u8bbf\u95ee\u5668\u51fa\u9519", (Throwable)e);
        }
    }

    private I18nVisitor createI18nVisitor(XmlNode node) throws Exception {
        if (node == null) {
            return null;
        }
        String beanName = node.getAttribute("name");
        LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7d\u6a21\u677f\u5f15\u64ce\u56fd\u9645\u5316\u8d44\u6e90\u8bbf\u95ee\u5668[{0}]", new Object[]{beanName});
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        return (I18nVisitor)BeanContainerFactory.getBeanContainer((ClassLoader)loader).getBean(beanName);
    }

    private ResourceLoader<?> createResourceLoader(XmlNode node) throws Exception {
        if (node == null) {
            return null;
        }
        String beanName = node.getAttribute("name");
        LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7d\u6a21\u677f\u5f15\u64ce\u7528\u6237\u6269\u5c55\u7684\u8d44\u6e90\u52a0\u8f7d\u5668[{0}]", new Object[]{beanName});
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        return (ResourceLoader)BeanContainerFactory.getBeanContainer((ClassLoader)loader).getBean(beanName);
    }

    private TemplateFunction createFunction(XmlNode node) throws Exception {
        if (node == null) {
            return null;
        }
        String beanName = node.getAttribute("name");
        LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7d\u6a21\u677f\u5f15\u64ce\u7684\u51fd\u6570[{0}]", new Object[]{beanName});
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        return (TemplateFunction)BeanContainerFactory.getBeanContainer((ClassLoader)loader).getBean(beanName);
    }

    private void addResourceLoaders(XmlNode totalConfig) {
        List list = totalConfig.getSubNodes(RESOURCE_CONFIG_NAME);
        if (list != null) {
            for (XmlNode node : list) {
                try {
                    ResourceLoader<?> loader = this.createResourceLoader(node);
                    this.templateEngine.addResourceLoader(loader);
                }
                catch (Exception e) {
                    LOGGER.errorMessage("\u52a0\u8f7d\u7528\u6237\u6269\u5c55\u7684\u8d44\u6e90\u52a0\u8f7d\u5668\u51fa\u9519", (Throwable)e);
                }
            }
        }
    }

    public void stop() {
    }

    public String getApplicationNodePath() {
        return "/application/template-config";
    }

    public String getComponentConfigPath() {
        return "/templateconfig.config.xml";
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        this.applicationConfig = applicationConfig;
        this.componentConfig = componentConfig;
    }

    public XmlNode getComponentConfig() {
        return this.componentConfig;
    }

    public XmlNode getApplicationConfig() {
        return this.applicationConfig;
    }

    public int getOrder() {
        return 0;
    }
}

