/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.tinygroup.template.Macro;
import org.tinygroup.template.listener.Point;

public class TemplateException
extends Exception {
    private static final long serialVersionUID = -7478199180490496722L;
    private transient ParserRuleContext context;
    private String fileName;
    private String originalMsg;
    private boolean showUpperMessage = true;
    private transient List<Macro> macroList;
    private transient Point startPoint;
    private transient Point endPoint;

    public TemplateException() {
    }

    public TemplateException(Exception e, ParserRuleContext tree, String fileName) {
        super(e);
        this.fileName = fileName;
        this.context = tree;
    }

    public TemplateException(String msg) {
        super(msg);
    }

    public TemplateException(Exception e) {
        super(e);
    }

    public TemplateException(Throwable cause) {
        super(cause);
    }

    public Point getStartPoint() {
        if (this.context != null && this.context.getStart() != null) {
            return new Point(this.context.getStart().getLine(), this.context.getStart().getCharPositionInLine());
        }
        return this.startPoint;
    }

    public Point getEndPoint() {
        if (this.context != null && this.context.getStart() != null) {
            return new Point(this.context.getStop().getLine(), this.context.getStop().getCharPositionInLine());
        }
        return this.endPoint;
    }

    public String getOriginalMsg() {
        return this.originalMsg;
    }

    public void setStartPoint(Point startPoint) {
        this.startPoint = startPoint;
    }

    public void setEndPoint(Point endPoint) {
        this.endPoint = endPoint;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTemplateText() {
        return this.context == null ? null : this.context.getText();
    }

    public ParserRuleContext getContext() {
        return this.context;
    }

    public void setContext(ParserRuleContext context, String fileName) {
        if (this.context == null) {
            this.context = context;
        }
        if (this.fileName == null) {
            this.fileName = fileName;
        }
    }

    public void setOriginalMsg(String originalMsg) {
        this.originalMsg = originalMsg;
    }

    public TemplateException(String msg, ParserRuleContext context, String fileName) {
        super(msg);
        this.context = context;
        this.fileName = fileName;
    }

    public String getMessage() {
        String pathInfo;
        String message = null;
        if (this.showUpperMessage) {
            message = super.getMessage();
        }
        if (this.macroList != null) {
            StringBuffer sb = new StringBuffer();
            for (Macro macro : this.macroList) {
                sb.append("\u5b8f\u6587\u4ef6\u8def\u5f84:").append(macro.getMacroPath()).append(",\u5b8f\u540d\u79f0:").append(macro.getName()).append("\n");
            }
            message = message != null ? message + sb.toString() : sb.toString();
        }
        String string = pathInfo = this.fileName == null ? "" : "\n\u8def\u5f84:" + this.fileName;
        if (this.context != null) {
            String contextMsg = pathInfo + "\n\u4f4d\u7f6e[" + this.context.getStart().getLine() + "," + this.context.getStart().getCharPositionInLine() + "]-[" + this.context.getStop().getLine() + "," + this.context.getStop().getCharPositionInLine() + "]\n" + "===================================================================\n" + this.context.getText() + "\n===================================================================\n";
            if (message != null) {
                return message + "\n" + contextMsg;
            }
            return contextMsg;
        }
        if (message == null) {
            return pathInfo;
        }
        if (message.startsWith("\n\u8def\u5f84:")) {
            return message;
        }
        return pathInfo + " " + message;
    }

    public boolean isShowUpperMessage() {
        return this.showUpperMessage;
    }

    public void setShowUpperMessage(boolean showUpperMessage) {
        this.showUpperMessage = showUpperMessage;
    }

    public void addMacro(Macro macro) {
        if (this.macroList == null) {
            this.macroList = new ArrayList<Macro>();
        }
        if (!this.macroList.contains(macro)) {
            this.macroList.add(macro);
        }
    }
}

