/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.parser.node;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.processor.Processor;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.NodeType;
import org.tinygroup.parser.node.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeImpl<T extends Node<T>, NT extends NodeType>
implements Node<T> {
    private Map<String, String> attributes;
    private List<Attribute> attributeList;
    private String content = null;
    private List<T> subNodes = new ArrayList<T>();
    private T parent = null;
    private NT nodeType = null;
    private String nodeName = null;
    private String singleAttribute;

    @Override
    public String getAttribute(String attributeName, String defaultValue) {
        String value = this.getAttribute(attributeName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        this.write(stream, "UTF-8");
    }

    public String getSingleAttribute() {
        return this.singleAttribute;
    }

    public void setSingleAttribute(String singleAttribute) {
        this.singleAttribute = singleAttribute;
    }

    protected abstract String encode(String var1);

    protected abstract String decode(String var1);

    public T setNodeName(String nodeName) {
        this.nodeName = this.getCaseSensitiveName(nodeName);
        return (T)this;
    }

    protected NodeImpl(NT nodeType) {
        this.nodeType = nodeType;
    }

    protected NodeImpl(String nodeName) {
        this.nodeName = this.getCaseSensitiveName(nodeName);
    }

    protected NodeImpl(NT nodeType, String nodeName) {
        this(nodeType);
        if (nodeType.isHasHeader()) {
            this.nodeName = this.getCaseSensitiveName(nodeName);
        }
    }

    protected NodeImpl(String nodeName, NT nodeType) {
        this(nodeType, nodeName);
    }

    public T setParent(T parent) {
        this.parent = parent;
        return (T)this;
    }

    public NT getNodeType() {
        return this.nodeType;
    }

    @Override
    public String getContent() {
        if (this.nodeType.isHasContent()) {
            return this.content;
        }
        StringBuffer sb = new StringBuffer();
        if (this.subNodes != null) {
            for (Node n : this.subNodes) {
                if (!n.getNodeType().isHasContent()) continue;
                sb.append(n.getContent());
            }
            return sb.toString();
        }
        return null;
    }

    public T setContent(String content) {
        String contentString = this.decode(content.trim());
        if (this.nodeType.isHasContent()) {
            this.content = this.nodeType.isText() ? this.decode(contentString) : contentString;
        } else {
            for (Node node : this.subNodes) {
                if (!node.getNodeType().isHasContent()) continue;
                node.setContent(content);
                return (T)this;
            }
            this.addContent(contentString);
        }
        return (T)this;
    }

    private String getEncodeContent() {
        if (this.nodeType.isText()) {
            return this.encode(this.content);
        }
        return this.content;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public List<Attribute> getAttributeList() {
        return this.attributeList;
    }

    public T setAttribute(Map<String, String> attributeMap) {
        if (attributeMap != null) {
            for (String name : attributeMap.keySet()) {
                String value = attributeMap.get(name);
                name = this.getCaseSensitiveName(name);
                this.setAttribute(name, value);
            }
        }
        return (T)this;
    }

    @Override
    public List<T> getSubNodes() {
        return this.subNodes;
    }

    @Override
    public List<T> getSubNodes(String nodeName) {
        if (this.subNodes == null) {
            return null;
        }
        nodeName = this.getCaseSensitiveName(nodeName);
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node t : this.subNodes) {
            if (t.getNodeName() == null || !t.getNodeName().equals(nodeName)) continue;
            result.add(t);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    @Override
    public List<T> getSubNodesRecursively(String nodeName) {
        if (this.subNodes == null) {
            return null;
        }
        nodeName = this.getCaseSensitiveName(nodeName);
        ArrayList result = new ArrayList();
        for (Node t : this.subNodes) {
            List progenyNodes;
            if (t.getNodeName() != null && t.getNodeName().equals(nodeName)) {
                result.add(t);
            }
            if ((progenyNodes = t.getSubNodesRecursively(nodeName)) == null || progenyNodes.size() <= 0) continue;
            result.addAll(progenyNodes);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    @Override
    public T getSubNodeRecursively(String nodeName) {
        if (this.subNodes == null) {
            return null;
        }
        nodeName = this.getCaseSensitiveName(nodeName);
        for (Node t : this.subNodes) {
            if (t.getNodeName() != null && t.getNodeName().equals(nodeName)) {
                return (T)t;
            }
            Object p = t.getSubNodeRecursively(nodeName);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @Override
    public String getCaseSensitiveName(String name) {
        if (!this.isCaseSensitive()) {
            name = name.toLowerCase();
        }
        return name;
    }

    public T getSubNode(String nodeName) {
        if (this.subNodes == null) {
            return null;
        }
        nodeName = this.getCaseSensitiveName(nodeName);
        for (Node t : this.subNodes) {
            if (t.getNodeName() == null || !t.getNodeName().equals(nodeName)) continue;
            return (T)t;
        }
        return null;
    }

    private String getFooterBuffer() {
        StringBuffer sb = new StringBuffer();
        if (this.nodeName != null && this.nodeType.isHasHeader()) {
            sb.append(this.nodeName);
        }
        return sb.toString();
    }

    private String getHeaderBuffer() {
        StringBuffer sb = new StringBuffer();
        if (this.nodeName != null) {
            sb.append(this.nodeName);
        }
        if (this.attributeList != null) {
            for (Attribute attribute : this.attributeList) {
                sb.append(" ");
                sb.append(attribute.getName()).append("=").append("\"").append(this.encode(attribute.getValue())).append("\"");
            }
        }
        if (this.singleAttribute != null) {
            sb.append(" ").append(this.singleAttribute);
        }
        return sb.toString();
    }

    @Override
    public void getHeader(StringBuffer sb) {
        this.nodeType.getHeader(sb, this.getHeaderBuffer());
    }

    @Override
    public void getFooter(StringBuffer sb) {
        if (!this.isSingleNode()) {
            this.nodeType.getTail(sb, this.getFooterBuffer());
        }
    }

    @Override
    public T getRoot() {
        NodeImpl<T, NT> n = this;
        while (n.getParent() != null) {
            n = n.getParent();
        }
        return (T)n;
    }

    @Override
    public T getParent() {
        return this.parent;
    }

    @Override
    public StringBuffer getBody() {
        StringBuffer sb = new StringBuffer();
        if (this.nodeType.isHasContent() && this.content != null) {
            sb.append(this.content);
        }
        if (this.nodeType.isHasBody() && this.subNodes != null) {
            for (Node n : this.subNodes) {
                sb.append(n.toStringBuffer());
            }
        }
        return sb;
    }

    @Override
    public StringBuffer toStringBuffer() {
        StringBuffer sb = new StringBuffer();
        this.getHeader(sb);
        if (this.content != null) {
            sb.append(this.getEncodeContent());
        }
        if (this.subNodes != null) {
            for (Node n : this.subNodes) {
                sb.append(n.toStringBuffer());
            }
        }
        this.getFooter(sb);
        return sb;
    }

    public void write(OutputStream stream, String encode) throws IOException {
        StringBuffer sb = new StringBuffer();
        this.getHeader(sb);
        stream.write(sb.toString().getBytes(encode));
        if (this.content != null) {
            stream.write(this.getEncodeContent().getBytes(encode));
        }
        if (this.subNodes != null) {
            for (Node n : this.subNodes) {
                n.write(stream);
            }
        }
        sb = new StringBuffer();
        this.getFooter(sb);
        stream.write(sb.toString().getBytes(encode));
    }

    @Override
    public String getAttribute(String attributeName) {
        if (this.attributes == null) {
            return null;
        }
        attributeName = this.getCaseSensitiveName(attributeName);
        return this.attributes.get(attributeName);
    }

    public T removeAttribute(String attributeName) {
        String name = this.getCaseSensitiveName(attributeName);
        this.attributes.remove(name);
        if (this.attributeList != null) {
            Iterator<Attribute> iterator = this.attributeList.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                if (!attribute.getName().equals(name)) continue;
                iterator.remove();
                break;
            }
        }
        return (T)this;
    }

    public T setAttribute(String attributeName, String value) {
        if (value == null) {
            this.removeAttribute(attributeName);
            return (T)this;
        }
        value = this.decode(value);
        if (this.nodeType.isHasHeader()) {
            String name;
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
                this.attributeList = new ArrayList<Attribute>();
            }
            if (this.attributes.containsKey(name = this.getCaseSensitiveName(attributeName))) {
                for (Attribute attribute : this.attributeList) {
                    if (!name.equals(attribute.getName())) continue;
                    attribute.setValue(value);
                    break;
                }
            } else {
                this.attributeList.add(new Attribute(name, value));
            }
            this.attributes.put(name, value);
        }
        return (T)this;
    }

    @Override
    public T addNode(T node) {
        if (!this.nodeType.isHasBody() || node == null) {
            return null;
        }
        if (this.subNodes == null) {
            this.subNodes = new ArrayList<T>();
        } else if (this.subNodes.contains(node)) {
            return (T)node;
        }
        node.setParent((NodeImpl)this);
        this.subNodes.add(node);
        return (T)node;
    }

    public List<T> addAll(List<T> nodes) {
        if (!((Object)this.subNodes).equals(nodes) && this.nodeType.isHasBody() && nodes != null) {
            for (Node t : nodes) {
                this.addNode(t);
            }
        }
        return nodes;
    }

    @Override
    public T removeNode(T node) {
        if (this.subNodes != null && this.subNodes.remove(node)) {
            node.setParent(null);
            return (T)node;
        }
        return null;
    }

    public List<T> removeSubNotes() {
        List<T> r = this.subNodes;
        this.subNodes = null;
        return r;
    }

    public String toString() {
        return this.toStringBuffer().toString();
    }

    public void foreach(Processor<T> processor) {
        processor.process((Object)this);
        if (this.subNodes != null) {
            for (Node n : this.subNodes) {
                n.foreach(processor);
            }
        }
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public boolean isSingleNode() {
        return false;
    }

    @Override
    public List<T> removeNode(String nodeName) {
        nodeName = this.getCaseSensitiveName(nodeName);
        ArrayList<Node> removedNodeList = new ArrayList<Node>();
        if (this.subNodes != null) {
            for (int i = this.subNodes.size() - 1; i >= 0; --i) {
                Node t = (Node)this.subNodes.get(i);
                if (t.getNodeName() == null || !t.getNodeName().equals(nodeName)) continue;
                removedNodeList.add(t);
                this.subNodes.remove(i);
            }
        }
        return removedNodeList;
    }
}

