/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.parser.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.NodeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFilterImpl<T extends Node<T>>
implements NodeFilter<T> {
    private Map<String, String> includeAttributeWithValue = null;
    private Map<String, String> excludeAttributeWithValue = null;
    private String[] includeAttribute = null;
    private String[] excludeAttribute = null;
    private String[] includeText = null;
    private String[] excludeText = null;
    private String[] includeNode = null;
    private String[] excludeNode = null;
    private String[] includeByNode = null;
    private String[] excludeByNode = null;
    private String[] xorSubNode = null;
    private String[] xorProperties = null;
    private T node = null;
    private String nodeName;

    public T getNode() {
        return this.node;
    }

    @Override
    public void init(T node) {
        this.node = node;
    }

    public AbstractFilterImpl() {
    }

    public AbstractFilterImpl(T node) {
        this.init(node);
    }

    @Override
    public NodeFilter setXorSubNode(String ... xorSubNode) {
        this.xorSubNode = xorSubNode;
        return this;
    }

    @Override
    public NodeFilter setXorProperties(String ... xorProperties) {
        this.xorProperties = xorProperties;
        return this;
    }

    protected boolean isRightNode(T node) {
        List sn;
        ArrayList<String> ancNodeNames;
        String content;
        if (this.xorSubNode != null && !this.checkXorSubNode(node)) {
            return false;
        }
        if (this.xorProperties != null && !this.checkXorProperties(node)) {
            return false;
        }
        if (this.includeText != null) {
            content = node.getContent();
            if (content == null) {
                return false;
            }
            for (String str : this.includeText) {
                if (content.indexOf(str) >= 0) continue;
                return false;
            }
        }
        if (this.excludeText != null && (content = node.getContent()) != null) {
            for (String str : this.excludeText) {
                if (content.indexOf(str) < 0) continue;
                return false;
            }
        }
        if (this.includeAttributeWithValue != null) {
            for (String key : this.includeAttributeWithValue.keySet()) {
                String value = node.getAttribute(key);
                if (value != null && value.equals(this.includeAttributeWithValue.get(key))) continue;
                return false;
            }
        }
        if (this.excludeAttributeWithValue != null) {
            for (String key : this.excludeAttributeWithValue.keySet()) {
                String value = node.getAttribute(key);
                if (value == null || !value.equals(this.excludeAttributeWithValue.get(key))) continue;
                return false;
            }
        }
        if (this.includeAttribute != null) {
            for (String key : this.includeAttribute) {
                if (node.getAttribute(key) != null) continue;
                return false;
            }
        }
        if (this.excludeAttribute != null) {
            for (String key : this.excludeAttribute) {
                if (node.getAttribute(key) == null) continue;
                return false;
            }
        }
        if (this.includeByNode != null) {
            ancNodeNames = new ArrayList<String>();
            this.ancestorNodeNames(node, ancNodeNames);
            for (String ancNodeName : ancNodeNames) {
                String[] arr$ = this.includeByNode;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String inByName = arr$[i$];
                    if (node.getCaseSensitiveName(ancNodeName).equals(node.getCaseSensitiveName(inByName))) continue;
                    return false;
                }
            }
        }
        if (this.excludeByNode != null) {
            ancNodeNames = new ArrayList();
            this.ancestorNodeNames(node, ancNodeNames);
            for (String ancNodeName : ancNodeNames) {
                for (String inByName : this.excludeByNode) {
                    if (!node.getCaseSensitiveName(ancNodeName).equals(node.getCaseSensitiveName(inByName))) continue;
                    return false;
                }
            }
        }
        if (this.includeNode != null) {
            sn = node.getSubNodes();
            if (sn == null || sn.size() == 0) {
                return false;
            }
            for (String inName : this.includeNode) {
                if (this.existNode(sn, inName)) continue;
                return false;
            }
        }
        if (this.excludeNode != null && (sn = node.getSubNodes()) != null && sn.size() > 0) {
            for (String inName : this.excludeNode) {
                if (!this.existNode(sn, inName)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkXorProperties(T node) {
        boolean r = false;
        for (String nodeName : this.xorProperties) {
            if (!node.getNodeType().isHasHeader() || node.getAttribute(nodeName) == null) continue;
            r = true;
            break;
        }
        return r;
    }

    private boolean checkXorSubNode(T node) {
        boolean r = false;
        for (String nodeName : this.xorSubNode) {
            if (nodeName.trim().length() == 0 || node.getSubNodes(nodeName) == null) continue;
            r = true;
            break;
        }
        return r;
    }

    private boolean existNode(List<T> nodes, String nodeName) {
        for (Node node : nodes) {
            if (node.getNodeName() == null || !node.getCaseSensitiveName(nodeName).equals(node.getCaseSensitiveName(node.getNodeName()))) continue;
            return true;
        }
        return false;
    }

    private void ancestorNodeNames(T node, List<String> list) {
        Object parent = node.getParent();
        if (parent != null) {
            if (parent.getNodeName() != null) {
                list.add(parent.getNodeName());
            }
            this.ancestorNodeNames(parent, list);
        }
    }

    protected List<T> filteNode(List<T> nodeWithPath) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node tNode : nodeWithPath) {
            if (!this.isRightNode(tNode)) continue;
            result.add(tNode);
        }
        return result;
    }

    @Override
    public NodeFilter setIncludeAttribute(Map<String, String> includeAttribute) {
        if (this.includeAttributeWithValue == null) {
            this.includeAttributeWithValue = includeAttribute;
        } else {
            this.includeAttributeWithValue.putAll(includeAttribute);
        }
        return this;
    }

    @Override
    public NodeFilter setIncludeAttribute(String key, String value) {
        if (this.includeAttributeWithValue == null) {
            this.includeAttributeWithValue = new HashMap<String, String>();
        }
        this.includeAttributeWithValue.put(key, value);
        return this;
    }

    @Override
    public NodeFilter setExcludeAttribute(Map<String, String> excludeAttribute) {
        if (this.excludeAttributeWithValue == null) {
            this.excludeAttributeWithValue = excludeAttribute;
        } else {
            this.excludeAttributeWithValue.putAll(excludeAttribute);
        }
        return this;
    }

    @Override
    public NodeFilter setIncludeText(String ... includeText) {
        this.includeText = includeText;
        return this;
    }

    @Override
    public NodeFilter setExcludeText(String ... excludeText) {
        this.excludeText = excludeText;
        return this;
    }

    @Override
    public NodeFilter setIncludeNode(String ... includeNode) {
        this.includeNode = includeNode;
        return this;
    }

    @Override
    public NodeFilter setExcludeNode(String ... excludeNode) {
        this.excludeNode = excludeNode;
        return this;
    }

    @Override
    public NodeFilter setIncludeByNode(String ... includeByNode) {
        this.includeByNode = includeByNode;
        return this;
    }

    @Override
    public NodeFilter setExcludeByNode(String ... excludeByNode) {
        this.excludeByNode = excludeByNode;
        return this;
    }

    @Override
    public NodeFilter clearCondition() {
        this.includeAttributeWithValue = null;
        this.excludeAttributeWithValue = null;
        this.includeText = null;
        this.excludeText = null;
        this.includeNode = null;
        this.excludeNode = null;
        this.includeByNode = null;
        this.excludeByNode = null;
        this.includeAttribute = null;
        this.excludeAttribute = null;
        this.xorSubNode = null;
        this.xorProperties = null;
        return this;
    }

    @Override
    public NodeFilter setIncludeAttributes(String ... includeAttribute) {
        this.includeAttribute = includeAttribute;
        return this;
    }

    @Override
    public NodeFilter setExcludeAttribute(String ... excludeAttribute) {
        this.excludeAttribute = excludeAttribute;
        return this;
    }

    @Override
    public T findNode(String nodeName) {
        List result = this.findNodeList(nodeName);
        if (result.size() == 0) {
            return null;
        }
        return (T)((Node)result.get(0));
    }

    @Override
    public NodeFilter setNodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Override
    public T findNode() {
        return this.findNode(this.nodeName);
    }

    @Override
    public List<T> findNodeList() {
        return this.findNodeList(this.nodeName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeList
    implements Comparable<NodeList> {
        private boolean caseSensitive;
        private String nodeName;
        private List<T> nodeList = new ArrayList();

        public NodeList(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public List<T> getNodeList() {
            return this.nodeList;
        }

        NodeList(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public int compareTo(NodeList o) {
            if (!this.caseSensitive) {
                return this.nodeName.toLowerCase().compareTo(o.nodeName.toLowerCase());
            }
            return this.nodeName.compareTo(o.nodeName);
        }
    }
}

