/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.logger.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;
import org.tinygroup.commons.i18n.LocaleUtil;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.context.Context;
import org.tinygroup.i18n.I18nMessage;
import org.tinygroup.i18n.I18nMessageFactory;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.logger.impl.LogBuffer;
import org.tinygroup.logger.impl.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerImpl
implements Logger {
    private static Pattern pattern = Pattern.compile("[{](.)*?[}]");
    private org.slf4j.Logger logger;
    protected MDCAdapter mdc = MDC.getMDCAdapter();
    private boolean supportTransaction = false;
    private ThreadLocal<LogBuffer> threadLocal = new ThreadLocal();
    private Map<String, String> mdcMap = new HashMap<String, String>();
    private static I18nMessage i18nMessage = I18nMessageFactory.getI18nMessages();
    private static final int DEFAULT_MAX_BUFFER_RECORDS = 80000;
    private int maxBufferRecords = 80000;
    private int bufferRecords = 0;

    @Override
    public boolean isSupportTransaction() {
        return this.supportTransaction;
    }

    @Override
    public void removeLogBuffer() {
        this.threadLocal.set(null);
    }

    @Override
    public synchronized LogBuffer getLogBuffer() {
        if (this.supportTransaction) {
            LogBuffer logBuffer = this.threadLocal.get();
            if (logBuffer == null) {
                logBuffer = new LogBuffer();
                this.threadLocal.set(logBuffer);
            }
            return logBuffer;
        }
        return null;
    }

    @Override
    public void setSupportTransaction(boolean supportBusiness) {
        this.supportTransaction = supportBusiness;
    }

    @Override
    public void startTransaction() {
        LogBuffer logBuffer = this.getLogBuffer();
        if (logBuffer != null) {
            logBuffer.increaseTransactionDepth();
        }
    }

    @Override
    public void endTransaction() {
        LogBuffer logBuffer = this.getLogBuffer();
        if (logBuffer != null) {
            logBuffer.decreaseTransactionDepth();
            if (logBuffer.getTimes() == 0) {
                this.flushLog(logBuffer);
                this.removeLogBuffer();
            }
        }
    }

    @Override
    public void flushTransaction() {
        LogBuffer logBuffer = this.getLogBuffer();
        if (logBuffer != null) {
            this.flushLog(logBuffer);
        }
    }

    @Override
    public void resetTransaction() {
        LogBuffer logBuffer = this.getLogBuffer();
        if (logBuffer != null) {
            logBuffer.reset();
            this.maxBufferRecords = 0;
        }
    }

    private void flushLog(LogBuffer logBuffer) {
        for (Message message : logBuffer.getLogMessages()) {
            if (message.getThrowable() != null && LogLevel.ERROR == message.getLevel()) {
                this.logError(message.getMessage(), message.getThrowable());
                continue;
            }
            if (message.getThrowable() != null && LogLevel.ERROR != message.getLevel()) {
                this.pLogMessage(message.getLevel(), message.getMessage(), message.getThrowable());
                continue;
            }
            this.pLogMessage(message.getLevel(), message.getMessage());
        }
        logBuffer.getLogMessages().clear();
        this.bufferRecords = 0;
    }

    @Override
    public org.slf4j.Logger getLogger() {
        return this.logger;
    }

    public LoggerImpl(org.slf4j.Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isEnabled(LogLevel logLevel) {
        switch (logLevel) {
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
            case WARN: {
                return this.logger.isWarnEnabled();
            }
            case TRACE: {
                return this.logger.isTraceEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
        }
        return true;
    }

    private void pLogMessage(LogLevel logLevel, String message) {
        this.putMdcVariable();
        switch (logLevel) {
            case DEBUG: {
                this.logger.debug(message);
                break;
            }
            case INFO: {
                this.logger.info(message);
                break;
            }
            case WARN: {
                this.logger.warn(message);
                break;
            }
            case TRACE: {
                this.logger.trace(message);
                break;
            }
            case ERROR: {
                this.logger.error(message);
            }
        }
    }

    private void putMdcVariable() {
        MDC.clear();
        this.putMdcVariable(this.mdcMap);
        this.putMdcVariable(LoggerFactory.getThreadVariableMap());
    }

    private void putMdcVariable(Map<String, String> mdcMap) {
        if (!CollectionUtil.isEmpty(mdcMap)) {
            for (Map.Entry<String, String> entry : mdcMap.entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                this.mdc.put(entry.getKey(), value);
            }
        }
    }

    @Override
    public void logMessage(LogLevel logLevel, String message) {
        if (!this.isEnabled(logLevel)) {
            return;
        }
        LogLevel threadLevel = LoggerFactory.getThreadLogLevel();
        if (threadLevel == null || threadLevel != null && logLevel.toString().equals(threadLevel.toString())) {
            this.exportLog(logLevel, message);
        }
    }

    private void exportLog(LogLevel logLevel, String message) {
        LogBuffer logBuffer = this.getLogBuffer();
        if (logBuffer != null && logBuffer.getTimes() > 0) {
            logBuffer.getLogMessages().add(new Message(logLevel, message, System.currentTimeMillis()));
            this.checkBufferSize(logBuffer);
        } else {
            this.pLogMessage(logLevel, message);
        }
    }

    @Override
    public void logMessage(LogLevel logLevel, String message, Throwable t) {
        if (!this.isEnabled(logLevel)) {
            return;
        }
        LogLevel threadLevel = LoggerFactory.getThreadLogLevel();
        if (threadLevel == null || threadLevel != null && logLevel.toString().equals(threadLevel.toString())) {
            this.exportLog(logLevel, message, t);
        }
    }

    private void exportLog(LogLevel logLevel, String message, Throwable t) {
        LogBuffer logBuffer = this.getLogBuffer();
        if (logBuffer != null && logBuffer.getTimes() > 0) {
            logBuffer.getLogMessages().add(new Message(logLevel, message, System.currentTimeMillis(), t));
            this.checkBufferSize(logBuffer);
        } else {
            this.pLogMessage(logLevel, message, t);
        }
    }

    private void pLogMessage(LogLevel logLevel, String message, Throwable t) {
        this.putMdcVariable();
        switch (logLevel) {
            case DEBUG: {
                this.logger.debug(message, t);
                break;
            }
            case INFO: {
                this.logger.info(message, t);
                break;
            }
            case WARN: {
                this.logger.warn(message, t);
                break;
            }
            case TRACE: {
                this.logger.trace(message, t);
                break;
            }
            case ERROR: {
                this.logger.error(message, t);
            }
        }
    }

    private void checkBufferSize(LogBuffer logBuffer) {
        ++this.bufferRecords;
        if (this.bufferRecords >= this.maxBufferRecords) {
            this.flushLog(logBuffer);
        }
    }

    @Override
    public void log(LogLevel logLevel, String code) {
        if (!this.isEnabled(logLevel)) {
            return;
        }
        this.logMessage(logLevel, i18nMessage.getMessage(code));
    }

    @Override
    public void log(LogLevel logLevel, Locale locale, String code, Object ... args) {
        if (!this.isEnabled(logLevel)) {
            return;
        }
        this.logMessage(logLevel, i18nMessage.getMessage(code, locale, null, args));
    }

    @Override
    public void log(LogLevel logLevel, String code, Object ... args) {
        if (!this.isEnabled(logLevel)) {
            return;
        }
        this.logMessage(logLevel, i18nMessage.getMessage(code, LocaleUtil.getContext().getLocale(), null, args));
    }

    @Override
    public void log(LogLevel logLevel, Locale locale, String code, Context context) {
        if (!this.isEnabled(logLevel)) {
            return;
        }
        this.logMessage(logLevel, i18nMessage.getMessage(code, context, locale));
    }

    @Override
    public void log(LogLevel logLevel, String code, Context context) {
        if (!this.isEnabled(logLevel)) {
            return;
        }
        this.logMessage(logLevel, i18nMessage.getMessage(code, context));
    }

    @Override
    public void logMessage(LogLevel logLevel, String message, Object ... args) {
        if (!this.isEnabled(logLevel)) {
            return;
        }
        this.logMessage(logLevel, this.format(message, args));
    }

    @Override
    public void logMessage(LogLevel logLevel, String message, Throwable t, Object ... args) {
        if (!this.isEnabled(logLevel)) {
            return;
        }
        this.logMessage(logLevel, this.format(message, args), t);
    }

    private String format(String message, Object ... args) {
        Matcher matcher = pattern.matcher(message);
        StringBuilder stringBuffer = new StringBuilder();
        int start = 0;
        int count = 0;
        while (matcher.find(start)) {
            stringBuffer.append(message.substring(start, matcher.start()));
            stringBuffer.append(args[count++]);
            start = matcher.end();
            if (count != args.length) continue;
        }
        stringBuffer.append(message.substring(start, message.length()));
        return stringBuffer.toString();
    }

    @Override
    public void logMessage(LogLevel logLevel, String message, Context context) {
        if (!this.isEnabled(logLevel)) {
            return;
        }
        this.logMessage(logLevel, i18nMessage.format(message, context));
    }

    @Override
    public void logMessage(LogLevel logLevel, String message, Throwable t, Context context) {
        if (!this.isEnabled(logLevel)) {
            return;
        }
        this.logMessage(logLevel, i18nMessage.format(message, context), t);
    }

    @Override
    public void error(String code) {
        if (!this.isEnabled(LogLevel.ERROR)) {
            return;
        }
        this.log(LogLevel.ERROR, i18nMessage.getMessage(code));
    }

    @Override
    public void error(String code, Throwable throwable) {
        if (!this.isEnabled(LogLevel.ERROR)) {
            return;
        }
        this.logError(i18nMessage.getMessage(code), throwable);
    }

    @Override
    public void error(String code, Throwable throwable, Object ... args) {
        if (!this.isEnabled(LogLevel.ERROR)) {
            return;
        }
        this.logError(i18nMessage.getMessage(code, LocaleUtil.getContext().getLocale(), null, args), throwable);
    }

    @Override
    public void error(String code, Throwable throwable, Context context) {
        if (!this.isEnabled(LogLevel.ERROR)) {
            return;
        }
        this.error(i18nMessage.format(code, context), throwable);
    }

    @Override
    public void errorMessage(String message) {
        if (!this.isEnabled(LogLevel.ERROR)) {
            return;
        }
        this.logMessage(LogLevel.ERROR, message);
    }

    @Override
    public void errorMessage(String message, Throwable throwable) {
        if (!this.isEnabled(LogLevel.ERROR)) {
            return;
        }
        this.logError(message, throwable);
    }

    @Override
    public void errorMessage(String message, Throwable throwable, Object ... args) {
        if (!this.isEnabled(LogLevel.ERROR)) {
            return;
        }
        this.logError(this.format(message, args), throwable);
    }

    @Override
    public void errorMessage(String message, Throwable throwable, Context context) {
        if (!this.isEnabled(LogLevel.ERROR)) {
            return;
        }
        this.logError(i18nMessage.format(message, context), throwable);
    }

    @Override
    public void error(Throwable throwable) {
        this.logError(throwable.getMessage(), throwable);
    }

    private void logError(String message, Throwable throwable) {
        if (!this.isEnabled(LogLevel.ERROR)) {
            return;
        }
        LogLevel threadLevel = LoggerFactory.getThreadLogLevel();
        if (threadLevel == null || threadLevel != null && LogLevel.ERROR.toString().equals(threadLevel.toString())) {
            LogBuffer logBuffer = this.getLogBuffer();
            if (logBuffer != null && logBuffer.getTimes() > 0) {
                logBuffer.getLogMessages().add(new Message(LogLevel.ERROR, message, System.currentTimeMillis(), throwable));
                this.checkBufferSize(logBuffer);
            } else {
                this.putMdcVariable();
                this.logger.error(message, throwable);
            }
        }
    }

    @Override
    public void putToMDC(String key, Object value) {
        this.mdcMap.put(key, value.toString());
    }

    @Override
    public void removeFromMDC(String key) {
        this.mdc.remove(key);
    }

    @Override
    public int getMaxBufferRecords() {
        return this.maxBufferRecords;
    }

    @Override
    public void setMaxBufferRecords(int maxBufferRecords) {
        this.maxBufferRecords = maxBufferRecords;
    }
}

