/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.ILoggerFactory;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.impl.LoggerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggerFactory {
    public static final String UUID_KEY = "logger.uuid";
    public static final String SERVICE_SERVICEID = "service.serviceId";
    public static final String SERVICE_EVENTID = "service.eventId";
    private static InheritableThreadLocal<Map<String, String>> threadVariableMap = new InheritableThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> childValue(Map<String, String> parentValue) {
            if (parentValue == null) {
                return null;
            }
            return new HashMap<String, String>(parentValue);
        }

        @Override
        protected Map<String, String> initialValue() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(LoggerFactory.UUID_KEY, StringUtils.remove((String)UUID.randomUUID().toString(), (String)"-"));
            return hashMap;
        }
    };
    private static InheritableThreadLocal<Map<String, String>> threadRpcVariableMap = new InheritableThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> childValue(Map<String, String> parentValue) {
            if (parentValue == null) {
                return null;
            }
            return new HashMap<String, String>(parentValue);
        }
    };
    private static ThreadLocal<LogLevel> threadLogLevel = new ThreadLocal();
    private static ConcurrentMap<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    private static List<String> rpcVariableKeyList = new ArrayList<String>();

    private LoggerFactory() {
    }

    public ILoggerFactory getILoggerFactory() {
        return org.slf4j.LoggerFactory.getILoggerFactory();
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        if (loggers.containsKey(name)) {
            return (Logger)loggers.get(name);
        }
        Logger logger = new LoggerImpl(org.slf4j.LoggerFactory.getLogger((String)name));
        Logger oldLogger = loggers.putIfAbsent(name, logger);
        if (null != oldLogger) {
            logger = oldLogger;
        }
        return logger;
    }

    public static void putThreadVariable(String key, String value) {
        LoggerFactory.putThreadVariable(key, value, threadVariableMap);
        if (LoggerFactory.isRpcVariableKey(key)) {
            LoggerFactory.putThreadVariable(key, value, threadRpcVariableMap);
        }
    }

    private static void putThreadVariable(String key, String value, InheritableThreadLocal<Map<String, String>> map) {
        HashMap<String, String> valueMap = (HashMap<String, String>)map.get();
        if (valueMap == null) {
            valueMap = new HashMap<String, String>();
            map.set(valueMap);
        }
        if (valueMap.size() <= 10000) {
            valueMap.put(key, value);
        }
    }

    public static void removeThreadVariable(String key) {
        LoggerFactory.removeThreadVariable(key, threadVariableMap);
        if (LoggerFactory.isRpcVariableKey(key)) {
            LoggerFactory.removeThreadVariable(key, threadRpcVariableMap);
        }
    }

    private static void removeThreadVariable(String key, InheritableThreadLocal<Map<String, String>> map) {
        Map valueMap = (Map)map.get();
        if (valueMap != null) {
            valueMap.remove(key);
        }
    }

    public static Map<String, String> getThreadVariableMap() {
        return (Map)threadVariableMap.get();
    }

    public static Map<String, String> getThreadRpcVariableMap() {
        HashMap<String, String> map = (HashMap<String, String>)threadRpcVariableMap.get();
        if (map == null) {
            map = new HashMap<String, String>();
            threadRpcVariableMap.set(map);
        }
        if (!map.containsKey(UUID_KEY)) {
            map.put(UUID_KEY, LoggerFactory.getThreadVariableMap().get(UUID_KEY));
        }
        return (Map)threadRpcVariableMap.get();
    }

    public static LogLevel getThreadLogLevel() {
        return threadLogLevel.get();
    }

    public static void setThreadLogLevel(LogLevel logLevel) {
        threadLogLevel.set(logLevel);
    }

    public static void clearAllLoggers() {
        loggers.clear();
        threadVariableMap.set(null);
        threadLogLevel.set(null);
    }

    public static void putRpcVariableKey(String key) {
        if (!rpcVariableKeyList.contains(key)) {
            rpcVariableKeyList.add(key);
        }
    }

    private static boolean isRpcVariableKey(String key) {
        return rpcVariableKeyList.contains(key);
    }

    static {
        rpcVariableKeyList.add(UUID_KEY);
        rpcVariableKeyList.add(SERVICE_EVENTID);
        rpcVariableKeyList.add(SERVICE_EVENTID);
    }
}

