/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoaderManager {
    private static Map<ClassLoader, List<String>> loaders = new HashMap<ClassLoader, List<String>>();
    private static Map<String, ClassLoader> classMap = new HashMap<String, ClassLoader>();
    private static Map<ClassLoader, List<String>> loaderMap = new HashMap<ClassLoader, List<String>>();

    private LoaderManager() {
    }

    public static ClassLoader getLoader(String className) throws ClassNotFoundException {
        if (LoaderManager.isSimple(className)) {
            return LoaderManager.class.getClassLoader();
        }
        if (classMap.containsKey(className)) {
            return classMap.get(className);
        }
        try {
            Class.forName(className);
            classMap.put(className, LoaderManager.class.getClassLoader());
            return LoaderManager.class.getClassLoader();
        }
        catch (ClassNotFoundException e) {
            for (ClassLoader loader : loaders.keySet()) {
                try {
                    loader.loadClass(className);
                    classMap.put(className, loader);
                    if (loaderMap.containsKey(loader)) {
                        loaderMap.get(loader).add(className);
                    } else {
                        ArrayList<String> classes = new ArrayList<String>();
                        classes.add(className);
                        loaderMap.put(loader, classes);
                    }
                    return loader;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException(className);
        }
    }

    public static void removeClassLoader(ClassLoader loader) {
        if (!loaderMap.containsKey(loader) && !loaders.containsKey(loader)) {
            return;
        }
        loaders.remove(loader);
        List<String> classes = loaderMap.remove(loader);
        if (classes == null) {
            return;
        }
        for (String className : classes) {
            if (classMap.get(className) != loader) continue;
            loaderMap.remove(className);
        }
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        if (LoaderManager.isSimple(className)) {
            return LoaderManager.getSimpleClass(className);
        }
        return LoaderManager.getLoader(className).loadClass(className);
    }

    public static void addClassLoader(ClassLoader loader, List<String> jarFiles) {
        if (!loaders.containsKey(loader)) {
            loaders.put(loader, jarFiles);
        }
    }

    public static List<String> getLoaderFiles(ClassLoader loader) {
        return loaders.get(loader);
    }

    private static boolean isSimple(String className) {
        if ("int".equals(className)) {
            return true;
        }
        if ("boolean".equals(className)) {
            return true;
        }
        if ("float".equals(className)) {
            return true;
        }
        if ("double".equals(className)) {
            return true;
        }
        if ("long".equals(className)) {
            return true;
        }
        if ("short".equals(className)) {
            return true;
        }
        if ("char".equals(className)) {
            return true;
        }
        return "byte".equals(className);
    }

    private static Class<?> getSimpleClass(String className) {
        if ("int".equals(className)) {
            return Integer.TYPE;
        }
        if ("boolean".equals(className)) {
            return Boolean.TYPE;
        }
        if ("float".equals(className)) {
            return Float.TYPE;
        }
        if ("double".equals(className)) {
            return Double.TYPE;
        }
        if ("long".equals(className)) {
            return Long.TYPE;
        }
        if ("short".equals(className)) {
            return Short.TYPE;
        }
        if ("char".equals(className)) {
            return Character.TYPE;
        }
        if ("byte".equals(className)) {
            return Byte.TYPE;
        }
        throw new RuntimeException(className + "\u4e0d\u662f\u57fa\u672c\u6570\u636e\u7c7b\u578b");
    }
}

