/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.ini.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.ini.IniException;
import org.tinygroup.ini.IniOperator;
import org.tinygroup.ini.Section;
import org.tinygroup.ini.Sections;
import org.tinygroup.ini.Utils;
import org.tinygroup.ini.ValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniOperatorDefault
implements IniOperator {
    private Sections sections = null;
    private String commentChar = ";";
    private static final Pattern SECTION_PATTERN = Pattern.compile("([\\[])(.*)([\\]])");
    private static final Pattern VALUE_PAIR_PATTERN = Pattern.compile("(.*)=(.*)");

    public IniOperatorDefault() {
    }

    public IniOperatorDefault(Sections sections) {
        this.sections = sections;
    }

    @Override
    public void setSections(Sections sections) {
        this.sections = sections;
    }

    @Override
    public Sections getSections() {
        return this.sections;
    }

    @Override
    public void read(InputStream inputStream, String charset) throws IOException, IniException {
        this.sections = new Sections();
        InputStreamReader reader = new InputStreamReader(inputStream, charset);
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = bufferedReader.readLine();
        String sectionName = null;
        while (string != null) {
            if ((string = string.trim()).length() != 0) {
                if (string.startsWith(this.commentChar)) {
                    this.addComment(sectionName, string);
                } else if (string.startsWith("[")) {
                    sectionName = this.addSection(string);
                } else {
                    this.addValuePair(string, sectionName);
                }
            }
            string = bufferedReader.readLine();
        }
        reader.close();
    }

    private void addValuePair(String string, String sectionName) throws IniException {
        Matcher matcher = VALUE_PAIR_PATTERN.matcher(string);
        if (matcher.find()) {
            String comment = string.substring(matcher.end()).trim();
            if (comment.length() > 0) {
                this.add(sectionName, new ValuePair(matcher.group(1).trim(), Utils.decode(matcher.group(2).trim()), comment.substring(1)));
            } else {
                this.add(sectionName, new ValuePair(matcher.group(1).trim(), Utils.decode(matcher.group(2).trim())));
            }
        } else {
            throw new IniException("\u4e0d\u7b26\u5168\u89c4\u8303\u7684\u5185\u5bb9\uff1a" + string);
        }
    }

    private String addSection(String string) throws IniException {
        Matcher matcher = SECTION_PATTERN.matcher(string);
        String sectionName = null;
        if (matcher.find()) {
            Section section;
            sectionName = Utils.decode(matcher.group(2).trim());
            String comment = string.substring(matcher.end()).trim();
            if (comment.startsWith(";")) {
                section = new Section(sectionName, comment.substring(1));
            } else if (comment.length() == 0) {
                section = new Section(sectionName);
            } else {
                throw new IniException("\u4e0d\u7b26\u5168\u89c4\u8303\u7684\u5185\u5bb9\uff1a" + string);
            }
            this.sections.addSection(section);
        }
        return sectionName;
    }

    private void addComment(String sectionName, String string) {
        ValuePair valuePair = new ValuePair(string.substring(1));
        this.add(sectionName, valuePair);
    }

    @Override
    public void write(OutputStream outputStream, String charset) throws IOException {
        if (this.sections != null) {
            for (Section section : this.sections.getSectionList()) {
                if (section.getName() != null) {
                    if (section.getComment() != null) {
                        outputStream.write(String.format("[%s];%s%n", Utils.encode(section.getName()), Utils.encode(section.getComment())).getBytes(charset));
                    } else {
                        outputStream.write(String.format("[%s]%n", Utils.encode(section.getName())).getBytes(charset));
                    }
                }
                for (ValuePair valuePair : section.getValuePairList()) {
                    if (valuePair.getKey() != null) {
                        if (valuePair.getComment() != null && valuePair.getComment().length() > 0) {
                            outputStream.write(String.format("%s=%s;%s%n", valuePair.getKey(), Utils.encode(valuePair.getValue()), valuePair.getComment()).getBytes(charset));
                            continue;
                        }
                        outputStream.write(String.format("%s=%s%n", valuePair.getKey(), Utils.encode(valuePair.getValue())).getBytes(charset));
                        continue;
                    }
                    outputStream.write(String.format(";%s%n", valuePair.getComment()).getBytes(charset));
                }
            }
        }
    }

    @Override
    public Section getSection(String sectionName) {
        if (this.sections != null) {
            return this.sections.getSection(sectionName);
        }
        return null;
    }

    @Override
    public void setCommentChar(char commentChar) {
        this.commentChar = commentChar + "";
    }

    @Override
    public <T> IniOperatorDefault put(String sectionName, String key, T value) {
        Section section = this.checkSection(sectionName);
        section.set(key, value);
        return this;
    }

    private Section checkSection(String sectionName) {
        Section section;
        if (this.sections == null) {
            this.sections = new Sections();
        }
        if ((section = this.sections.getSection(sectionName)) == null) {
            section = new Section(sectionName);
            this.sections.addSection(section);
        }
        return section;
    }

    @Override
    public <T> IniOperatorDefault add(String sectionName, String key, T value) {
        this.add(sectionName, new ValuePair(key, value.toString()));
        return this;
    }

    @Override
    public <T> T get(Class<T> tClass, String sectionName, String key, T defaultValue) {
        return null;
    }

    @Override
    public String get(String sectionName, String key, String defaultValue) {
        String value = this.get(sectionName, key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public String get(String sectionName, String key) {
        Section section = this.sections.getSection(sectionName);
        if (section != null) {
            return section.getValue(key);
        }
        return null;
    }

    @Override
    public <T> List<T> getList(Class<T> tClass, String sectionName, String key) {
        ArrayList<T> list = new ArrayList<T>();
        Section section = this.getSection(sectionName);
        if (section != null) {
            for (ValuePair valuePair : section.getValuePairList()) {
                if (!valuePair.getKey().equals(key)) continue;
                list.add(valuePair.getValue(tClass));
            }
        }
        return list;
    }

    @Override
    public <T> T get(Class<T> tClass, String sectionName, String key) {
        T value;
        Section section = this.sections.getSection(sectionName);
        if (section != null && (value = section.getValue(tClass, key)) != null) {
            return value;
        }
        return null;
    }

    @Override
    public IniOperatorDefault add(String sectionName, ValuePair valuePair) {
        Section section = this.checkSection(sectionName);
        section.add(valuePair);
        return this;
    }

    @Override
    public IniOperatorDefault set(String sectionName, ValuePair valuePair) {
        for (Section section : this.sections.getSectionList()) {
            Iterator<ValuePair> i$;
            if (!sectionName.equals(section.getName()) || !(i$ = section.getValuePairList().iterator()).hasNext()) continue;
            ValuePair pair = i$.next();
            if (pair.getKey().equals(valuePair.getKey())) {
                pair.setValue(valuePair.getValue());
            }
            return this;
        }
        return this.add(sectionName, valuePair);
    }

    @Override
    public IniOperatorDefault add(String sectionName, List<ValuePair> valuePairList) {
        Section section = this.checkSection(sectionName);
        section.getValuePairList().addAll(valuePairList);
        return this;
    }

    @Override
    public List<ValuePair> getValuePairList(String sectionName, String key) {
        Section section = this.sections.getSection(sectionName);
        if (section != null) {
            return section.getValuePairList(key);
        }
        return null;
    }

    @Override
    public ValuePair getValuePair(String sectionName, String key) {
        Section section = this.sections.getSection(sectionName);
        if (section != null) {
            return section.getValuePair(key);
        }
        return null;
    }
}

