/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.i18n.impl;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.commons.i18n.LocaleUtil;
import org.tinygroup.context.Context;
import org.tinygroup.format.Formater;
import org.tinygroup.i18n.I18nMessage;
import org.tinygroup.i18n.I18nMessageFactory;

public class I18nMessageImpl
implements I18nMessage {
    private static final String CONTEXT_LOCALE_KEY = "contextLocale";
    private static Pattern pattern = Pattern.compile("[{](.)*?[}]");
    private Formater formater;
    private String localeKey = "contextLocale";

    public String getLocaleKey() {
        return this.localeKey;
    }

    public void setLocaleKey(String localeKey) {
        this.localeKey = localeKey;
    }

    public Formater getFormater() {
        return this.formater;
    }

    public void setFormater(Formater formatter) {
        this.formater = formatter;
    }

    private String format(String message, Object ... args) {
        Matcher matcher = pattern.matcher(message);
        StringBuilder stringBuffer = new StringBuilder();
        int start = 0;
        int count = 0;
        while (matcher.find(start)) {
            stringBuffer.append(message.substring(start, matcher.start()));
            stringBuffer.append(args[count++]);
            start = matcher.end();
        }
        if (args.length != count) {
            throw new RuntimeException(String.format("\u5360\u4f4d\u7b26[%s]\u548c\u53c2\u6570[%s]\u957f\u5ea6\u4e0d\u5339\u914d\uff1a", args.length, count));
        }
        stringBuffer.append(message.substring(start, message.length()));
        return stringBuffer.toString();
    }

    public String getMessage(String code, Object ... args) {
        return this.getMessage(code, LocaleUtil.getContext().getLocale(), args);
    }

    public String getMessage(String code, Locale locale, Object ... args) {
        String message = I18nMessageFactory.getMessage(locale, code);
        if (message == null) {
            return null;
        }
        return this.format(message, args);
    }

    public String getMessage(String code) {
        return I18nMessageFactory.getMessage(code);
    }

    public String getMessage(String code, Locale locale) {
        return I18nMessageFactory.getMessage(locale, code);
    }

    public String getMessage(String code, Context context) {
        String string = I18nMessageFactory.getMessage(LocaleUtil.getContext().getLocale(), code);
        return this.formater.format(context, string);
    }

    public String format(String message, Context context) {
        return this.formater.format(context, message);
    }

    public String getMessage(String code, Context context, Locale locale) {
        String string = I18nMessageFactory.getMessage(locale, code);
        return this.formater.format(context, string);
    }

    public Locale getContextLocale(Context context) {
        Locale locale = (Locale)context.get(this.localeKey);
        if (locale == null) {
            locale = LocaleUtil.getContext().getLocale();
        }
        return locale;
    }

    public String getMessage(String code, String defaultMessage, Object ... args) {
        String message = this.getMessage(code, args);
        return this.getRealMessage(defaultMessage, message);
    }

    public String getMessage(String code, Locale locale, String defaultMessage, Object ... args) {
        String message = this.getMessage(code, locale, args);
        return this.getRealMessage(defaultMessage, message);
    }

    public String getMessage(String code, String defaultMessage) {
        String message = this.getMessage(code);
        return this.getRealMessage(defaultMessage, message);
    }

    public String getMessage(String code, Locale locale, String defaultMessage) {
        String message = this.getMessage(code, locale);
        return this.getRealMessage(defaultMessage, message);
    }

    public String getMessage(String code, String defaultMessage, Context context) {
        String message = this.getMessage(code, context);
        return this.getRealMessage(defaultMessage, message);
    }

    public String getMessage(String code, String defaultMessage, Context context, Locale locale) {
        String message = this.getMessage(code, context, locale);
        return this.getRealMessage(defaultMessage, message);
    }

    private String getRealMessage(String defaultMessage, String message) {
        if (message == null) {
            return defaultMessage;
        }
        return message;
    }
}

