/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.i18n.impl;

import java.util.Locale;
import org.tinygroup.commons.i18n.LocaleUtil;
import org.tinygroup.context.Context;
import org.tinygroup.format.Formater;
import org.tinygroup.i18n.I18nMessageContext;
import org.tinygroup.i18n.I18nMessageFactory;

public class I18nMessageContextImpl
implements I18nMessageContext {
    private Formater formater;

    public void setFormater(Formater formatter) {
        this.formater = formatter;
    }

    public String getMessage(String code) {
        return this.getMessage(code, LocaleUtil.getContext().getLocale());
    }

    public String getMessage(String code, Locale locale) {
        return I18nMessageFactory.getMessage(locale, code);
    }

    public String getMessage(String code, Context context) {
        return this.getMessage(code, context, this.getContextLocale(context));
    }

    public String getMessage(String code, Context context, Locale locale) {
        String string = this.getMessage(code, locale);
        return this.formater.format(context, string);
    }

    public String format(String message, Context context) {
        return this.formater.format(context, message);
    }

    public Locale getContextLocale(Context context) {
        Locale locale = (Locale)context.get("contextLocale");
        if (locale == null) {
            locale = LocaleUtil.getContext().getLocale();
        }
        return locale;
    }

    public Formater getFormater() {
        return this.formater;
    }

    public String getMessage(String code, String defaultMessage) {
        String message = this.getMessage(code);
        return this.getRealMessage(defaultMessage, message);
    }

    public String getMessage(String code, Locale locale, String defaultMessage) {
        String message = this.getMessage(code, locale);
        return this.getRealMessage(defaultMessage, message);
    }

    public String getMessage(String code, String defaultMessage, Context context) {
        String message = this.getMessage(code, context);
        return this.getRealMessage(defaultMessage, message);
    }

    public String getMessage(String code, String defaultMessage, Context context, Locale locale) {
        String message = this.getMessage(code, context, locale);
        return this.getRealMessage(defaultMessage, message);
    }

    private String getRealMessage(String defaultMessage, String message) {
        if (message == null) {
            return defaultMessage;
        }
        return message;
    }
}

