/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.i18n;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.tinygroup.commons.i18n.LocaleUtil;
import org.tinygroup.context.Context;
import org.tinygroup.format.Formater;
import org.tinygroup.i18n.I18nMessage;
import org.tinygroup.i18n.I18nMessageContext;
import org.tinygroup.i18n.I18nMessageStandard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class I18nMessages
implements I18nMessage {
    private List<I18nMessageStandard> i18nMessageStandards;
    private List<I18nMessageContext> i18nMessageContexts;
    private Formater formater;

    public List<I18nMessageStandard> getI18nMessageStandards() {
        return this.i18nMessageStandards;
    }

    public void setI18nMessageStandards(List<I18nMessageStandard> i18nMessageStandards) {
        this.i18nMessageStandards = i18nMessageStandards;
    }

    public List<I18nMessageContext> getI18nMessageContexts() {
        return this.i18nMessageContexts;
    }

    public void setI18nMessageContexts(List<I18nMessageContext> i18nMessageContexts) {
        this.i18nMessageContexts = i18nMessageContexts;
        for (I18nMessageContext messageContext : i18nMessageContexts) {
            if (messageContext.getFormater() != null) continue;
            messageContext.setFormater(this.formater);
        }
    }

    @Override
    public String getMessage(String code, Context context) {
        return this.getMessage(code, context, LocaleUtil.getContext().getLocale());
    }

    @Override
    public String getMessage(String code, Context context, Locale locale) {
        String message;
        block1: {
            I18nMessageContext m;
            message = null;
            if (this.i18nMessageContexts == null) break block1;
            Iterator<I18nMessageContext> i$ = this.i18nMessageContexts.iterator();
            while (i$.hasNext() && (message = (m = i$.next()).getMessage(code, context, locale)) == null) {
            }
        }
        return message;
    }

    @Override
    public String getMessage(String code) {
        return this.getMessage(code, LocaleUtil.getContext().getLocale());
    }

    private String getStandardMessage(String code, Locale locale, Object ... args) {
        String message;
        block1: {
            I18nMessageStandard m;
            message = null;
            if (this.i18nMessageStandards == null) break block1;
            Iterator<I18nMessageStandard> i$ = this.i18nMessageStandards.iterator();
            while (i$.hasNext() && (message = (m = i$.next()).getMessage(code, locale, null, args)) == null) {
            }
        }
        return message;
    }

    private String getContextMessage(String code, Locale locale) {
        String message;
        block1: {
            I18nMessageContext m;
            message = null;
            if (this.i18nMessageContexts == null) break block1;
            Iterator<I18nMessageContext> i$ = this.i18nMessageContexts.iterator();
            while (i$.hasNext() && (message = (m = i$.next()).getMessage(code, locale)) == null) {
            }
        }
        return message;
    }

    @Override
    public String format(String msg, Context context) {
        String message;
        block1: {
            I18nMessageContext m;
            message = null;
            if (this.i18nMessageContexts == null) break block1;
            Iterator<I18nMessageContext> i$ = this.i18nMessageContexts.iterator();
            while (i$.hasNext() && (message = (m = i$.next()).format(msg, context)) == null) {
            }
        }
        return message;
    }

    @Override
    public void setFormater(Formater formater) {
        this.formater = formater;
    }

    @Override
    public Formater getFormater() {
        return this.formater;
    }

    @Override
    public String getMessage(String code, String defaultMessage, Object ... args) {
        String message = this.getMessage(code, LocaleUtil.getContext().getLocale(), null, args);
        return this.getRealMessage(defaultMessage, message);
    }

    @Override
    public String getMessage(String code, Locale locale, String defaultMessage, Object ... args) {
        String message = this.getStandardMessage(code, locale, args);
        return this.getRealMessage(defaultMessage, message);
    }

    private String getRealMessage(String defaultMessage, String message) {
        if (StringUtils.isBlank((String)message)) {
            return defaultMessage;
        }
        return message;
    }

    @Override
    public String getMessage(String code, String defaultMessage, Context context) {
        String message = this.getMessage(code, context);
        return this.getRealMessage(defaultMessage, message);
    }

    @Override
    public String getMessage(String code, String defaultMessage, Context context, Locale locale) {
        String message = this.getMessage(code, context, locale);
        return this.getRealMessage(defaultMessage, message);
    }

    @Override
    public String getMessage(String code, Locale locale) {
        String message = null;
        message = this.getStandardMessage(code, locale, new Object[0]);
        if (message != null) {
            return message;
        }
        message = this.getContextMessage(code, locale);
        if (message != null) {
            return message;
        }
        return null;
    }
}

