/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.i18n;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.tinygroup.commons.i18n.LocaleUtil;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.format.Formater;
import org.tinygroup.format.PatternDefine;
import org.tinygroup.format.config.FormatPatternDefine;
import org.tinygroup.format.config.FormatProvider;
import org.tinygroup.format.impl.DefaultPatternDefine;
import org.tinygroup.i18n.I18nMessageContext;
import org.tinygroup.i18n.I18nMessageStandard;
import org.tinygroup.i18n.I18nMessages;
import org.tinygroup.i18n.config.I18nConfiguration;
import org.tinygroup.i18n.config.I18nMessage;
import org.tinygroup.i18n.exception.I18nException;
import org.tinygroup.i18n.impl.I18nMessageContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class I18nMessageFactory {
    private static Map<Locale, List<Properties>> customizeResourceMap = new HashMap<Locale, List<Properties>>();
    private static Map<Locale, List<Properties>> resourceMap = new HashMap<Locale, List<Properties>>();
    private static Locale defaultLocale = LocaleUtil.getContext().getLocale();
    private static I18nMessages i18nMessages = new I18nMessages();

    private I18nMessageFactory() {
    }

    private static <T> T getObject(String className) throws I18nException {
        try {
            Class<?> clazz = Class.forName(className);
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            throw new I18nException(e);
        }
    }

    public static void setI18nMessages(I18nMessages i18nMessages) {
        I18nMessageFactory.i18nMessages = i18nMessages;
    }

    public static I18nMessages getI18nMessages() {
        return i18nMessages;
    }

    public static void cleanResource() {
        resourceMap.clear();
    }

    public static void addResource(Locale locale, Properties properties) {
        List<Properties> propertiesList = resourceMap.get(locale);
        if (propertiesList == null) {
            propertiesList = new ArrayList<Properties>();
            resourceMap.put(locale, propertiesList);
        }
        propertiesList.add(properties);
    }

    public static void removeResource(Locale locale, Properties properties) {
        List<Properties> propertiesList = resourceMap.get(locale);
        if (!CollectionUtil.isEmpty(propertiesList)) {
            propertiesList.remove(properties);
        }
    }

    public static void addCustomizeResource(Locale locale, Properties properties) {
        List<Properties> propertiesList = customizeResourceMap.get(locale);
        if (propertiesList == null) {
            propertiesList = new ArrayList<Properties>();
            customizeResourceMap.put(locale, propertiesList);
        }
        propertiesList.add(properties);
    }

    public static void removeCustomizeResource(Locale locale, Properties properties) {
        List<Properties> propertiesList = customizeResourceMap.get(locale);
        if (!CollectionUtil.isEmpty(propertiesList)) {
            propertiesList.remove(properties);
        }
    }

    public static String getMessage(String key) {
        return I18nMessageFactory.getMessage(LocaleUtil.getContext().getLocale(), key);
    }

    public static String getMessage(Locale locale, String key) {
        String message = I18nMessageFactory.getMessage(customizeResourceMap, locale, key);
        if (message != null) {
            return message;
        }
        return I18nMessageFactory.getMessage(resourceMap, locale, key);
    }

    private static String getMessage(Map<Locale, List<Properties>> map, Locale locale, String key) {
        List<Properties> propertiesList = map.get(locale);
        if (propertiesList == null) {
            propertiesList = map.get(defaultLocale);
        }
        if (propertiesList != null) {
            for (Properties properties : propertiesList) {
                String value = properties.getProperty(key);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    static {
        XStream stream = new XStream();
        stream.autodetectAnnotations(true);
        stream.alias("i18n-configuration", I18nConfiguration.class);
        stream.setClassLoader(I18nConfiguration.class.getClassLoader());
        I18nConfiguration configuration = (I18nConfiguration)stream.fromXML(I18nMessageFactory.class.getResourceAsStream("/I18nConfiguration.xml"));
        ArrayList<I18nMessageStandard> i18nMessageStandards = new ArrayList<I18nMessageStandard>();
        for (I18nMessage msg : configuration.getI18nMessageStandards()) {
            try {
                I18nMessageStandard object = (I18nMessageStandard)I18nMessageFactory.getObject(msg.getClassName());
                i18nMessageStandards.add(object);
            }
            catch (I18nException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<I18nMessageContext> i18nMessageContexts = new ArrayList<I18nMessageContext>();
        try {
            Formater formatter = (Formater)I18nMessageFactory.getObject(configuration.getFormater().getClassName());
            DefaultPatternDefine patternHandle = new DefaultPatternDefine();
            FormatPatternDefine formatPatternDefine = configuration.getFormater().getFormatPatternDefine();
            patternHandle.setPrefixPatternString(formatPatternDefine.getPrefixPatternString());
            patternHandle.setPatternString(formatPatternDefine.getPatternString());
            patternHandle.setPostfixPatternString(formatPatternDefine.getPostfixPatternString());
            formatter.setPatternHandle((PatternDefine)patternHandle);
            HashMap<String, org.tinygroup.format.FormatProvider> formatProviders = new HashMap<String, org.tinygroup.format.FormatProvider>();
            for (FormatProvider formatProvider : configuration.getFormater().getFormatProviders()) {
                org.tinygroup.format.FormatProvider fp = (org.tinygroup.format.FormatProvider)I18nMessageFactory.getObject(formatProvider.getClassName());
                formatProviders.put(formatProvider.getArea(), fp);
            }
            formatter.setFormatProviders(formatProviders);
            for (I18nMessage msg : configuration.getI18nMessageContexts()) {
                I18nMessageContextImpl object = (I18nMessageContextImpl)I18nMessageFactory.getObject(msg.getClassName());
                i18nMessageContexts.add(object);
                object.setFormater(formatter);
            }
        }
        catch (I18nException e) {
            throw new RuntimeException(e);
        }
        i18nMessages.setI18nMessageStandards(i18nMessageStandards);
        i18nMessages.setI18nMessageContexts(i18nMessageContexts);
    }
}

