/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fileresolver.impl;

import java.util.List;
import org.tinygroup.fileresolver.ProcessorCallBack;
import org.tinygroup.fileresolver.impl.FileProcessorThread;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.threadgroup.MultiThreadProcessor;
import org.tinygroup.threadgroup.Processor;
import org.tinygroup.vfs.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiThreadFileProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiThreadFileProcessor.class);

    private MultiThreadFileProcessor() {
    }

    public static void multiProcessor(int threadNum, String mutiThreadName, List<FileObject> fileObjects, ProcessorCallBack callBack) {
        MultiThreadProcessor processors = new MultiThreadProcessor(mutiThreadName);
        int fileNums = fileObjects.size();
        int numOfEachThread = fileNums % threadNum == 0 ? fileNums / threadNum : fileNums / threadNum + 1;
        int fromIndex = 0;
        for (int i = 0; i < threadNum; ++i) {
            int endIndex = fromIndex + numOfEachThread;
            if (endIndex > fileNums) {
                endIndex = fileNums;
            }
            List<FileObject> files = fileObjects.subList(fromIndex, endIndex);
            fromIndex += numOfEachThread;
            FileProcessorThread processor = new FileProcessorThread(String.format("file-processor-thread-%d", i), files);
            processor.setCallBack(callBack);
            processors.addProcessor((Processor)processor);
        }
        long startTime = System.currentTimeMillis();
        processors.start();
        long endTime = System.currentTimeMillis();
        LOGGER.logMessage(LogLevel.INFO, "\u7ebf\u7a0b\u7ec4:<{}>\u6267\u884c\u65f6\u95f4\uff1a{}", new Object[]{mutiThreadName, endTime - startTime});
    }
}

