/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fileresolver.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.ini.Section;
import org.tinygroup.ini.ValuePair;
import org.tinygroup.ini.impl.IniOperatorDefault;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.PathFilter;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class LocalPropertiesFileProcessor
extends AbstractFileProcessor {
    private static final String APPLICATION_PROPERTIES_PROPERTY = "/application/application-properties/property";
    private static final String APPLICATION_PROPERTIES_FILE = "/application/application-properties/file";
    String applicationConfig;

    public LocalPropertiesFileProcessor(String applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public void process() {
        LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u8bfb\u53d6\u672c\u5730Application\u53d8\u91cf\u914d\u7f6e\u4fe1\u606f");
        XmlNode xmlNode = (XmlNode)new XmlStringParser().parse(this.applicationConfig).getRoot();
        LocalPropertiesFileProcessor.loadApplicationProperties(xmlNode);
        this.loadApplicationPropertyFiles(xmlNode);
        LOGGER.logMessage(LogLevel.INFO, "\u8bfb\u53d6\u672c\u5730Application\u53d8\u91cf\u914d\u7f6e\u4fe1\u606f\u5b8c\u6210");
    }

    protected boolean checkMatch(FileObject fileObject) {
        return false;
    }

    private static void loadApplicationProperties(XmlNode applicationConfig) {
        PathFilter filter = new PathFilter((Node)applicationConfig);
        List propertyList = filter.findNodeList(APPLICATION_PROPERTIES_PROPERTY);
        for (XmlNode property : propertyList) {
            String name = property.getAttribute("name");
            String value = property.getAttribute("value");
            ConfigurationUtil.getConfigurationManager().getConfiguration().put(name, value);
        }
    }

    private void loadApplicationPropertyFiles(XmlNode applicationConfig) {
        PathFilter filter = new PathFilter((Node)applicationConfig);
        List propertyList = filter.findNodeList(APPLICATION_PROPERTIES_FILE);
        for (XmlNode property : propertyList) {
            String path = property.getAttribute("path");
            if (path.endsWith(".ini")) {
                this.loadApplicationPropertyIniFile(path);
                continue;
            }
            if (!path.endsWith(".properties")) continue;
            this.loadApplicationPropertyPropertiesFile(path);
        }
    }

    private void loadApplicationPropertyPropertiesFile(String path) {
        Properties p = new Properties();
        InputStream in = ConfigurationUtil.class.getResourceAsStream(path);
        try {
            p.load(in);
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6:" + path + "\u65f6\u51fa\u9519", e);
        }
        if (p.size() <= 0) {
            return;
        }
        for (Object key : p.keySet()) {
            String value = p.getProperty(key.toString());
            ConfigurationUtil.getConfigurationManager().getConfiguration().put(key.toString(), value);
        }
    }

    private void loadApplicationPropertyIniFile(String path) {
        IniOperatorDefault operator = new IniOperatorDefault();
        try {
            File file = new File(ConfigurationUtil.class.getClassLoader().getResource(path).toURI());
            operator.read((InputStream)new FileInputStream(file), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6:" + path + "\u65f6\u51fa\u9519", e);
        }
        List sectionList = operator.getSections().getSectionList();
        for (Section section : sectionList) {
            List valuePairs = section.getValuePairList();
            for (ValuePair valuePair : valuePairs) {
                String key = valuePair.getKey();
                String value = valuePair.getValue();
                ConfigurationUtil.getConfigurationManager().getConfiguration().put(key, value);
            }
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

