/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fileresolver.impl;

import java.io.IOException;
import java.util.Collection;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.config.Configuration;
import org.tinygroup.config.ConfigurationManager;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xmlparser.node.XmlNode;

public class ConfigurationFileProcessor
extends AbstractFileProcessor {
    private static final String CONFIG_EXT_FILENAME = ".config.xml";

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().toLowerCase().endsWith(CONFIG_EXT_FILENAME);
    }

    public void process() {
        ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager();
        if (!CollectionUtil.isEmpty((Collection)this.deleteList) || !CollectionUtil.isEmpty((Collection)this.changeList)) {
            for (FileObject fileObject : this.deleteList) {
                LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664\u7ec4\u4ef6\u914d\u7f6e\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
                configurationManager.getComponentConfigurationMap().remove(fileObject.getPath());
                LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664\u7ec4\u4ef6\u914d\u7f6e\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
            }
            for (FileObject fileObject : this.changeList) {
                LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u8bfb\u53d6\u7ec4\u4ef6\u914d\u7f6e\u6587\u4ef6:{0}", new Object[]{fileObject.getFileName()});
                try {
                    XmlNode xmlNode = ConfigurationUtil.parseXmlFromFileObject((FileObject)fileObject);
                    configurationManager.setComponentConfiguration(fileObject.getPath(), xmlNode);
                    LOGGER.logMessage(LogLevel.INFO, "\u8bfb\u53d6\u7ec4\u4ef6\u914d\u7f6e\u6587\u4ef6:{0}\u5b8c\u6210", new Object[]{fileObject.getFileName()});
                }
                catch (IOException e) {
                    LOGGER.errorMessage("\u8bfb\u53d6\u7ec4\u4ef6\u914d\u7f6e\u6587\u4ef6:{0}\u65f6\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e, new Object[]{fileObject.getFileName()});
                }
            }
            configurationManager.setConfigurationList(BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBeans(Configuration.class));
            configurationManager.distributeConfiguration();
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

