/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fileresolver.applicationprocessor;

import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.config.impl.AbstractConfiguration;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.xmlparser.node.XmlNode;

public class FileMonitorProcessor
extends AbstractConfiguration
implements ApplicationProcessor {
    private static final String FILE_MONITOR_NODE_PATH = "/application/file-monitor";
    private static final int DEFAULT_INTERVAL = 5;
    private FileMonitorThread thread = null;
    private int interval = 5;
    private boolean enable = false;
    private FileResolver resolver;
    private byte[] synObject = new byte[0];

    public FileResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(FileResolver resolver) {
        this.resolver = resolver;
    }

    public String getApplicationNodePath() {
        return FILE_MONITOR_NODE_PATH;
    }

    public String getComponentConfigPath() {
        return "/filemonitor.config.xml";
    }

    public void start() {
        XmlNode combineNode = ConfigurationUtil.combineXmlNode((XmlNode)this.applicationConfig, (XmlNode)this.componentConfig);
        if (combineNode != null) {
            String enableString;
            String strInterrupt = combineNode.getAttribute("interval");
            if (strInterrupt != null && strInterrupt.length() > 0) {
                this.interval = Integer.parseInt(strInterrupt);
            }
            if ((enableString = combineNode.getAttribute("enable")) != null && enableString.length() > 0) {
                this.enable = Boolean.valueOf(enableString);
            }
        }
        if (this.enable) {
            if (this.thread != null) {
                this.thread.stop = true;
            }
            this.thread = new FileMonitorThread();
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        byte[] byArray = this.synObject;
        synchronized (this.synObject) {
            if (this.enable && this.thread != null && this.thread.isAlive()) {
                this.thread.stop = true;
                this.synObject.notify();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setApplication(Application application) {
    }

    public int getOrder() {
        return 0;
    }

    public void init() {
    }

    private class FileMonitorThread
    extends Thread {
        private static final int MILLISECOND_PER_SECOND = 1000;
        private volatile boolean stop = false;

        private FileMonitorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stop) {
                try {
                    byte[] byArray = FileMonitorProcessor.this.synObject;
                    synchronized (byArray) {
                        FileMonitorProcessor.this.synObject.wait(FileMonitorProcessor.this.interval * 1000);
                        if (!this.stop) {
                            LOGGER.logMessage(LogLevel.INFO, "\u5b9a\u65f6\u626b\u63cf\u6587\u4ef6\u53d8\u5316......");
                            FileMonitorProcessor.this.resolver = (FileResolver)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("fileResolver");
                            FileMonitorProcessor.this.resolver.refresh();
                            LOGGER.logMessage(LogLevel.INFO, "\u5b9a\u65f6\u626b\u63cf\u6587\u4ef6\u7ed3\u675f.");
                        }
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.errorMessage(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

