/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.cache.ehcache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Element;
import org.tinygroup.cache.Cache;
import org.tinygroup.cache.CacheManager;
import org.tinygroup.cache.exception.CacheException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhCache
implements Cache {
    private CacheManager cacheManager;
    private static final String GROUP_MAP = "group_map";
    private net.sf.ehcache.CacheManager manager = net.sf.ehcache.CacheManager.getInstance();
    private net.sf.ehcache.Cache cache;

    private String getKey(String group, String key) {
        return String.format("%s:%s", group, key);
    }

    public void init(String region) {
        this.cache = this.manager.getCache(region);
    }

    public Object get(String key) {
        Element element = this.cache.get((Serializable)((Object)key));
        if (element == null) {
            throw new CacheException(String.format("key:<%s> not found.", key));
        }
        return element.getObjectValue();
    }

    public void put(String key, Object object) {
        Element element = new Element((Object)key, object);
        this.cache.put(element);
    }

    public void putSafe(String key, Object object) {
        if (this.cache.get((Serializable)((Object)key)) != null) {
            throw new CacheException("");
        }
        Element element = new Element((Object)key, object);
        this.cache.put(element);
    }

    public void put(String groupName, String key, Object object) {
        Element element = this.cache.get((Serializable)((Object)GROUP_MAP));
        Map groupMap = null;
        groupMap = element == null ? new HashMap() : (Map)element.getObjectValue();
        HashSet<String> keysSet = (HashSet<String>)groupMap.get(groupName);
        if (keysSet == null) {
            keysSet = new HashSet<String>();
            groupMap.put(groupName, keysSet);
        }
        keysSet.add(key);
        this.put(this.getKey(groupName, key), object);
        this.put(GROUP_MAP, groupMap);
    }

    public Object get(String groupName, String key) {
        return this.get(this.getKey(groupName, key));
    }

    public Set<String> getGroupKeys(String group) {
        Map groupMap = (Map)this.cache.get((Serializable)((Object)GROUP_MAP)).getObjectValue();
        return (Set)groupMap.get(group);
    }

    public void cleanGroup(String group) {
        Set<String> groupKeys = this.getGroupKeys(group);
        if (groupKeys != null) {
            for (String key : groupKeys) {
                this.remove(group, key);
            }
        }
    }

    public void clear() {
        this.cache.removeAll();
    }

    public void remove(String key) {
        this.cache.remove((Serializable)((Object)key));
    }

    public void remove(String group, String key) {
        Set<String> groupKeys = this.getGroupKeys(group);
        if (groupKeys == null) {
            throw new CacheException(String.format("group <%s> not found.", group));
        }
        this.cache.remove((Serializable)((Object)this.getKey(group, key)));
    }

    public String getStats() {
        return this.cache.getStatistics().toString();
    }

    public int freeMemoryElements(int numberToFree) {
        throw new CacheException("ehcache does not support this feature.");
    }

    public void destroy() {
        this.cacheManager.removeCache((Cache)this);
    }

    public void setCacheManager(CacheManager manager) {
        this.cacheManager = manager;
    }
}

