/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.cache;

import junit.framework.TestCase;
import org.tinygroup.cache.Cache;
import org.tinygroup.cache.exception.CacheException;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.fileresolver.FileResolverFactory;
import org.tinygroup.fileresolver.impl.I18nFileProcessor;
import org.tinygroup.fileresolver.impl.SpringBeansFileProcessor;
import org.tinygroup.fileresolver.impl.XStreamFileProcessor;
import org.tinygroup.springutil.SpringUtil;

public class CacheTest
extends TestCase {
    Cache cache;

    protected void setUp() throws Exception {
        super.setUp();
        this.cache = (Cache)SpringUtil.getBean((String)"ehCache");
        this.cache.init("DC");
        this.cache.clear();
    }

    public void testGetString() throws CacheException {
        this.cache.put("aa", (Object)"123");
        CacheTest.assertEquals((Object)"123", (Object)this.cache.get("aa"));
    }

    public void testPutSafe() {
        try {
            this.cache.putSafe("aa", (Object)123);
            this.cache.putSafe("aa", (Object)"bb");
            CacheTest.fail();
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    public void testPutStringStringObject() throws CacheException {
        this.cache.put("group", "aa", (Object)"123");
        CacheTest.assertEquals((Object)"123", (Object)this.cache.get("group", "aa"));
    }

    public void testGetGroupKeys() throws CacheException {
        this.cache.put("groupa", "aa1", (Object)"123");
        this.cache.put("groupa", "aa2", (Object)"123");
        this.cache.put("groupa", "aa3", (Object)"123");
        CacheTest.assertEquals((int)3, (int)this.cache.getGroupKeys("groupa").size());
    }

    public void testCleanGroup() throws CacheException {
        this.cache.put("bb", (Object)"123");
        this.cache.put("group", "aa1", (Object)"123");
        this.cache.put("group", "aa2", (Object)"123");
        this.cache.put("group", "aa3", (Object)"123");
        this.cache.cleanGroup("group");
        try {
            this.cache.get("group", "aa1");
            CacheTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testClear() throws CacheException {
        this.cache.put("bb", (Object)"123");
        CacheTest.assertEquals((Object)"123", (Object)this.cache.get("bb"));
        this.cache.clear();
        try {
            this.cache.get("bb");
            CacheTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testRemoveStringString() throws CacheException {
        this.cache.put("group", "bb", (Object)"123");
        CacheTest.assertEquals((Object)"123", (Object)this.cache.get("group", "bb"));
        this.cache.remove("group", "bb");
        try {
            this.cache.get("group", "bb");
            CacheTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testRemove() throws CacheException {
        this.cache.put("bb", (Object)"123");
        CacheTest.assertEquals((Object)"123", (Object)this.cache.get("bb"));
        this.cache.remove("bb");
        try {
            this.cache.get("bb");
            CacheTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetStats() {
        System.out.println(System.getProperty("user.dir"));
        System.out.println(this.cache.getStats());
    }

    public void testFreeMemoryElements() throws CacheException {
        this.cache.put("aa", (Object)"aa");
        for (int i = 0; i < 100; ++i) {
            this.cache.put("aa" + i, (Object)i);
        }
        for (int j = 0; j < 500; ++j) {
            this.cache.get("aa");
        }
        try {
            this.cache.freeMemoryElements(100);
            CacheTest.assertEquals((Object)"aa", (Object)this.cache.get("aa"));
            this.cache.get("aa1");
            CacheTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        FileResolverFactory.getFileResolver().addFileProcessor((FileProcessor)new XStreamFileProcessor());
        FileResolverFactory.getFileResolver().addFileProcessor((FileProcessor)new I18nFileProcessor());
        FileResolverFactory.getFileResolver().addFileProcessor((FileProcessor)new SpringBeansFileProcessor());
        FileResolverFactory.getFileResolver().resolve();
    }
}

