/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.tools;

import java.util.Collection;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.BasicConstant;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    private static final char[] DIGITS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] DIGITS_NOCASE = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final Pattern CRLF_PATTERN = Pattern.compile("\\r|\\n|\\r\\n");

    public static int getLength(String str) {
        return str == null ? 0 : str.length();
    }

    public static boolean isEqualsIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isBlank(String str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String defaultIfEmpty(String str, String defaultStr) {
        return str == null || str.length() == 0 ? defaultStr : str;
    }

    public static String defaultIfBlank(String str, String defaultStr) {
        return StringUtil.isBlank(str) ? defaultStr : str;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToNull(String str) {
        if (str == null) {
            return null;
        }
        String result = str.trim();
        if (result == null || result.length() == 0) {
            return null;
        }
        return result;
    }

    public static String trimToEmpty(String str) {
        if (str == null) {
            return "";
        }
        return str.trim();
    }

    public static String trim(String str, String stripChars) {
        return StringUtil.trim(str, stripChars, 0);
    }

    public static String trimStart(String str) {
        return StringUtil.trim(str, null, -1);
    }

    public static String trimStart(String str, String stripChars) {
        return StringUtil.trim(str, stripChars, -1);
    }

    public static String trimEnd(String str) {
        return StringUtil.trim(str, null, 1);
    }

    public static String trimEnd(String str, String stripChars) {
        return StringUtil.trim(str, stripChars, 1);
    }

    public static String trimToNull(String str, String stripChars) {
        String result = StringUtil.trim(str, stripChars);
        if (result == null || result.length() == 0) {
            return null;
        }
        return result;
    }

    public static String trimToEmpty(String str, String stripChars) {
        String result = StringUtil.trim(str, stripChars);
        if (result == null) {
            return "";
        }
        return result;
    }

    private static String trim(String str, String stripChars, int mode) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        int end = length;
        if (mode <= 0) {
            if (stripChars == null) {
                for (start = 0; start < end && Character.isWhitespace(str.charAt(start)); ++start) {
                }
            } else {
                if (stripChars.length() == 0) {
                    return str;
                }
                while (start < end && stripChars.indexOf(str.charAt(start)) != -1) {
                    ++start;
                }
            }
        }
        if (mode >= 0) {
            if (stripChars == null) {
                while (start < end && Character.isWhitespace(str.charAt(end - 1))) {
                    --end;
                }
            } else {
                if (stripChars.length() == 0) {
                    return str;
                }
                while (start < end && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                    --end;
                }
            }
        }
        if (start > 0 || end < length) {
            return str.substring(start, end);
        }
        return str;
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static String uncapitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        if (strLen > 1 && Character.isUpperCase(str.charAt(1)) && Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toLowerCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static String swapCase(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        StringBuilder buffer = new StringBuilder(strLen);
        char ch = '\u0000';
        for (int i = 0; i < strLen; ++i) {
            ch = str.charAt(i);
            if (Character.isUpperCase(ch)) {
                ch = Character.toLowerCase(ch);
            } else if (Character.isTitleCase(ch)) {
                ch = Character.toLowerCase(ch);
            } else if (Character.isLowerCase(ch)) {
                ch = Character.toUpperCase(ch);
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String toUpperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String toLowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String toCamelCase(String str) {
        return new WordTokenizer(){

            protected void startSentence(StringBuilder buffer, char ch) {
                buffer.append(Character.toLowerCase(ch));
            }

            protected void startWord(StringBuilder buffer, char ch) {
                if (!this.isDelimiter(buffer.charAt(buffer.length() - 1))) {
                    buffer.append(Character.toUpperCase(ch));
                } else {
                    buffer.append(Character.toLowerCase(ch));
                }
            }

            protected void inWord(StringBuilder buffer, char ch) {
                buffer.append(Character.toLowerCase(ch));
            }

            protected void startDigitSentence(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            protected void startDigitWord(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            protected void inDigitWord(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            protected void inDelimiter(StringBuilder buffer, char ch) {
                if (ch != '_') {
                    buffer.append(ch);
                }
            }
        }.parse(str);
    }

    public static String toPascalCase(String str) {
        return new WordTokenizer(){

            protected void startSentence(StringBuilder buffer, char ch) {
                buffer.append(Character.toUpperCase(ch));
            }

            protected void startWord(StringBuilder buffer, char ch) {
                buffer.append(Character.toUpperCase(ch));
            }

            protected void inWord(StringBuilder buffer, char ch) {
                buffer.append(Character.toLowerCase(ch));
            }

            protected void startDigitSentence(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            protected void startDigitWord(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            protected void inDigitWord(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            protected void inDelimiter(StringBuilder buffer, char ch) {
                if (ch != '_') {
                    buffer.append(ch);
                }
            }
        }.parse(str);
    }

    public static String toUpperCaseWithUnderscores(String str) {
        return new WordTokenizer(){

            protected void startSentence(StringBuilder buffer, char ch) {
                buffer.append(Character.toUpperCase(ch));
            }

            protected void startWord(StringBuilder buffer, char ch) {
                if (!this.isDelimiter(buffer.charAt(buffer.length() - 1))) {
                    buffer.append('_');
                }
                buffer.append(Character.toUpperCase(ch));
            }

            protected void inWord(StringBuilder buffer, char ch) {
                buffer.append(Character.toUpperCase(ch));
            }

            protected void startDigitSentence(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            protected void startDigitWord(StringBuilder buffer, char ch) {
                if (!this.isDelimiter(buffer.charAt(buffer.length() - 1))) {
                    buffer.append('_');
                }
                buffer.append(ch);
            }

            protected void inDigitWord(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            protected void inDelimiter(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }
        }.parse(str);
    }

    public static String toLowerCaseWithUnderscores(String str) {
        return new WordTokenizer(){

            protected void startSentence(StringBuilder buffer, char ch) {
                buffer.append(Character.toLowerCase(ch));
            }

            protected void startWord(StringBuilder buffer, char ch) {
                if (!this.isDelimiter(buffer.charAt(buffer.length() - 1))) {
                    buffer.append('_');
                }
                buffer.append(Character.toLowerCase(ch));
            }

            protected void inWord(StringBuilder buffer, char ch) {
                buffer.append(Character.toLowerCase(ch));
            }

            protected void startDigitSentence(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            protected void startDigitWord(StringBuilder buffer, char ch) {
                if (!this.isDelimiter(buffer.charAt(buffer.length() - 1))) {
                    buffer.append('_');
                }
                buffer.append(ch);
            }

            protected void inDigitWord(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            protected void inDelimiter(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }
        }.parse(str);
    }

    public static String[] split(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return BasicConstant.EMPTY_STRING_ARRAY;
        }
        LinkedList<String> list = CollectionUtil.createLinkedList();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < length) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] split(String str, String separatorChars) {
        return StringUtil.split(str, separatorChars, -1);
    }

    public static String[] split(String str, String separatorChars, int max) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return BasicConstant.EMPTY_STRING_ARRAY;
        }
        LinkedList<String> list = CollectionUtil.createLinkedList();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        if (separatorChars == null) {
            while (i < length) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = length;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < length) {
                if (str.charAt(i) == sep) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = length;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        } else {
            while (i < length) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = length;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String join(Object[] array, String separator) {
        int bufSize;
        int arraySize;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        if ((arraySize = array.length) == 0) {
            bufSize = 0;
        } else {
            int firstLength = array[0] == null ? 16 : array[0].toString().length();
            bufSize = arraySize * (firstLength + separator.length());
        }
        StringBuilder buf = new StringBuilder(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (separator != null && i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Iterable<?> list, String separator) {
        if (list == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(256);
        Iterator<?> i = list.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj != null) {
                buf.append(obj);
            }
            if (separator == null || !i.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static int indexOf(String str, char searchChar) {
        if (str == null || str.length() == 0) {
            return -1;
        }
        return str.indexOf(searchChar);
    }

    public static int indexOf(String str, char searchChar, int startPos) {
        if (str == null || str.length() == 0) {
            return -1;
        }
        return str.indexOf(searchChar, startPos);
    }

    public static int indexOf(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return str.indexOf(searchStr);
    }

    public static int indexOf(String str, String searchStr, int startPos) {
        if (str == null || searchStr == null) {
            return -1;
        }
        if (searchStr.length() == 0 && startPos >= str.length()) {
            return str.length();
        }
        return str.indexOf(searchStr, startPos);
    }

    public static int indexOfAny(String str, char[] searchChars) {
        if (str == null || str.length() == 0 || searchChars == null || searchChars.length == 0) {
            return -1;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            for (char searchChar : searchChars) {
                if (searchChar != ch) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfAny(String str, String searchChars) {
        if (str == null || str.length() == 0 || searchChars == null || searchChars.length() == 0) {
            return -1;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < searchChars.length(); ++j) {
                if (searchChars.charAt(j) != ch) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfAny(String str, String[] searchStrs) {
        if (str == null || searchStrs == null) {
            return -1;
        }
        int sz = searchStrs.length;
        int ret = Integer.MAX_VALUE;
        int tmp = 0;
        for (int i = 0; i < sz; ++i) {
            String search = searchStrs[i];
            if (search == null || (tmp = str.indexOf(search)) == -1 || tmp >= ret) continue;
            ret = tmp;
        }
        return ret == Integer.MAX_VALUE ? -1 : ret;
    }

    public static int indexOfAnyBut(String str, char[] searchChars) {
        if (str == null || str.length() == 0 || searchChars == null || searchChars.length == 0) {
            return -1;
        }
        block0: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < searchChars.length; ++j) {
                if (searchChars[j] == ch) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOfAnyBut(String str, String searchChars) {
        if (str == null || str.length() == 0 || searchChars == null || searchChars.length() == 0) {
            return -1;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (searchChars.indexOf(str.charAt(i)) >= 0) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(String str, char searchChar) {
        if (str == null || str.length() == 0) {
            return -1;
        }
        return str.lastIndexOf(searchChar);
    }

    public static int lastIndexOf(String str, char searchChar, int startPos) {
        if (str == null || str.length() == 0) {
            return -1;
        }
        return str.lastIndexOf(searchChar, startPos);
    }

    public static int lastIndexOf(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return str.lastIndexOf(searchStr);
    }

    public static int lastIndexOf(String str, String searchStr, int startPos) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return str.lastIndexOf(searchStr, startPos);
    }

    public static int lastIndexOfAny(String str, String[] searchStrs) {
        if (str == null || searchStrs == null) {
            return -1;
        }
        int searchStrsLength = searchStrs.length;
        int index = -1;
        int tmp = 0;
        for (int i = 0; i < searchStrsLength; ++i) {
            String search = searchStrs[i];
            if (search == null || (tmp = str.lastIndexOf(search)) <= index) continue;
            index = tmp;
        }
        return index;
    }

    public static boolean contains(String str, char searchChar) {
        if (str == null || str.length() == 0) {
            return false;
        }
        return str.indexOf(searchChar) >= 0;
    }

    public static boolean contains(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        return str.indexOf(searchStr) >= 0;
    }

    public static boolean containsOnly(String str, char[] valid) {
        if (valid == null || str == null) {
            return false;
        }
        if (str.length() == 0) {
            return true;
        }
        if (valid.length == 0) {
            return false;
        }
        return StringUtil.indexOfAnyBut(str, valid) == -1;
    }

    public static boolean containsOnly(String str, String valid) {
        if (str == null || valid == null) {
            return false;
        }
        return StringUtil.containsOnly(str, valid.toCharArray());
    }

    public static boolean containsNone(String str, char[] invalid) {
        if (str == null || invalid == null) {
            return true;
        }
        int strSize = str.length();
        int validSize = invalid.length;
        for (int i = 0; i < strSize; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < validSize; ++j) {
                if (invalid[j] != ch) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsNone(String str, String invalidChars) {
        if (str == null || invalidChars == null) {
            return true;
        }
        return StringUtil.containsNone(str, invalidChars.toCharArray());
    }

    public static int countMatches(String str, String subStr) {
        if (str == null || str.length() == 0 || subStr == null || subStr.length() == 0) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(subStr, index)) != -1) {
            ++count;
            index += subStr.length();
        }
        return count;
    }

    public static String substring(String str, int start) {
        if (str == null) {
            return null;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return "";
        }
        return str.substring(start);
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static String left(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    public static String right(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(str.length() - len);
    }

    public static String mid(String str, int pos, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0 || pos > str.length()) {
            return "";
        }
        if (pos < 0) {
            pos = 0;
        }
        if (str.length() <= pos + len) {
            return str.substring(pos);
        }
        return str.substring(pos, pos + len);
    }

    public static String substringBefore(String str, String separator) {
        if (str == null || separator == null || str.length() == 0) {
            return str;
        }
        if (separator.length() == 0) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfter(String str, String separator) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String substringBeforeLast(String str, String separator) {
        if (str == null || separator == null || str.length() == 0 || separator.length() == 0) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfterLast(String str, String separator) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (separator == null || separator.length() == 0) {
            return "";
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String substringBetween(String str, String tag) {
        return StringUtil.substringBetween(str, tag, tag, 0);
    }

    public static String substringBetween(String str, String open, String close) {
        return StringUtil.substringBetween(str, open, close, 0);
    }

    public static String substringBetween(String str, String open, String close, int fromIndex) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open, fromIndex);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static String deleteWhitespace(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(sz);
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            buffer.append(str.charAt(i));
        }
        return buffer.toString();
    }

    public static String replace(String text, String repl, String with) {
        return StringUtil.replace(text, repl, with, -1);
    }

    public static String replace(String text, String repl, String with, int max) {
        if (text == null || repl == null || with == null || repl.length() == 0 || max == 0) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String replaceChar(String str, char searchChar, char replaceChar) {
        if (str == null) {
            return null;
        }
        return str.replace(searchChar, replaceChar);
    }

    public static String replaceChars(String str, String searchChars, String replaceChars) {
        if (str == null || str.length() == 0 || searchChars == null || searchChars.length() == 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        boolean modified = false;
        int isize = searchChars.length();
        for (int i = 0; i < isize; ++i) {
            char searchChar = searchChars.charAt(i);
            if (replaceChars == null || i >= replaceChars.length()) {
                int pos = 0;
                for (int j = 0; j < len; ++j) {
                    if (chars[j] != searchChar) {
                        chars[pos++] = chars[j];
                        continue;
                    }
                    modified = true;
                }
                len = pos;
                continue;
            }
            for (int j = 0; j < len; ++j) {
                if (chars[j] != searchChar) continue;
                chars[j] = replaceChars.charAt(i);
                modified = true;
            }
        }
        if (!modified) {
            return str;
        }
        return new String(chars, 0, len);
    }

    public static String overlay(String str, String overlay, int start, int end) {
        if (str == null) {
            return null;
        }
        if (overlay == null) {
            overlay = "";
        }
        int len = str.length();
        if (start < 0) {
            start = 0;
        }
        if (start > len) {
            start = len;
        }
        if (end < 0) {
            end = 0;
        }
        if (end > len) {
            end = len;
        }
        if (start > end) {
            int temp = start;
            start = end;
            end = temp;
        }
        return new StringBuilder(len + start - end + overlay.length() + 1).append(str.substring(0, start)).append(overlay).append(str.substring(end)).toString();
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return "";
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                char ch = str.charAt(0);
                char[] output1 = new char[outputLength];
                for (int i = repeat - 1; i >= 0; --i) {
                    output1[i] = ch;
                }
                return new String(output1);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(str);
        }
        return buf.toString();
    }

    public static String chomp(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            char ch = str.charAt(0);
            if (ch == '\r' || ch == '\n') {
                return "";
            }
            return str;
        }
        int lastIdx = str.length() - 1;
        char last = str.charAt(lastIdx);
        if (last == '\n') {
            if (str.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else if (last != '\r') {
            ++lastIdx;
        }
        return str.substring(0, lastIdx);
    }

    public static String chomp(String str, String separator) {
        if (str == null || str.length() == 0 || separator == null) {
            return str;
        }
        if (str.endsWith(separator)) {
            return str.substring(0, str.length() - separator.length());
        }
        return str;
    }

    public static String chop(String str) {
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (strLen < 2) {
            return "";
        }
        int lastIdx = strLen - 1;
        String ret = str.substring(0, lastIdx);
        char last = str.charAt(lastIdx);
        if (last == '\n' && ret.charAt(lastIdx - 1) == '\r') {
            return ret.substring(0, lastIdx - 1);
        }
        return ret;
    }

    public static String reverse(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return new StringBuilder(str).reverse().toString();
    }

    public static String reverseDelimited(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        Object[] strs = StringUtil.split(str, separatorChar);
        ArrayUtil.arrayReverse(strs);
        return StringUtil.join(strs, String.valueOf(separatorChar));
    }

    public static String reverseDelimited(String str, String separatorChars, String separator) {
        if (str == null) {
            return null;
        }
        Object[] strs = StringUtil.split(str, separatorChars);
        ArrayUtil.arrayReverse(strs);
        if (separator == null) {
            return StringUtil.join(strs, " ");
        }
        return StringUtil.join(strs, separator);
    }

    public static String abbreviate(String str, int maxWidth) {
        return StringUtil.abbreviate(str, 0, maxWidth);
    }

    public static String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            maxWidth = 4;
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        if (offset > str.length()) {
            offset = str.length();
        }
        if (str.length() - offset < maxWidth - 3) {
            offset = str.length() - (maxWidth - 3);
        }
        if (offset <= 4) {
            return str.substring(0, maxWidth - 3) + "...";
        }
        if (maxWidth < 7) {
            maxWidth = 7;
        }
        if (offset + maxWidth - 3 < str.length()) {
            return "..." + StringUtil.abbreviate(str.substring(offset), maxWidth - 3);
        }
        return "..." + str.substring(str.length() - (maxWidth - 3));
    }

    public static String difference(String str1, String str2) {
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        int index = StringUtil.indexOfDifference(str1, str2);
        if (index == -1) {
            return "";
        }
        return str2.substring(index);
    }

    public static int indexOfDifference(String str1, String str2) {
        int i;
        if (str1 == str2 || str1 == null || str2 == null) {
            return -1;
        }
        for (i = 0; i < str1.length() && i < str2.length() && str1.charAt(i) == str2.charAt(i); ++i) {
        }
        if (i < str2.length() || i < str1.length()) {
            return i;
        }
        return -1;
    }

    public static String longToString(long longValue) {
        return StringUtil.longToString(longValue, false);
    }

    public static String longToString(long longValue, boolean noCase) {
        char[] digits = noCase ? DIGITS_NOCASE : DIGITS;
        int digitsLength = digits.length;
        if (longValue == 0L) {
            return String.valueOf(digits[0]);
        }
        if (longValue < 0L) {
            longValue = -longValue;
        }
        StringBuilder strValue = new StringBuilder();
        while (longValue != 0L) {
            int digit = (int)(longValue % (long)digitsLength);
            longValue /= (long)digitsLength;
            strValue.append(digits[digit]);
        }
        return strValue.toString();
    }

    public static String bytesToString(byte[] bytes) {
        return StringUtil.bytesToString(bytes, false);
    }

    public static String bytesToString(byte[] bytes, boolean noCase) {
        char[] digits = noCase ? DIGITS_NOCASE : DIGITS;
        int digitsLength = digits.length;
        if (ArrayUtil.isEmptyArray(bytes)) {
            return String.valueOf(digits[0]);
        }
        StringBuilder strValue = new StringBuilder();
        int value = 0;
        int limit = 0x7FFFFF;
        int i = 0;
        while (true) {
            if (i < bytes.length && value < limit) {
                value = (value << 8) + (0xFF & bytes[i++]);
                continue;
            }
            while (value >= digitsLength) {
                strValue.append(digits[value % digitsLength]);
                value /= digitsLength;
            }
            if (i >= bytes.length) break;
        }
        if (value != 0 || strValue.length() == 0) {
            strValue.append(digits[value]);
        }
        return strValue.toString();
    }

    public static String indent(String str, String indent) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder();
        StringUtil.indent(buf, str, indent);
        return buf.toString();
    }

    public static void indent(Formatter buf, String str, String indent) {
        if (buf.out() instanceof StringBuilder) {
            StringUtil.indent((StringBuilder)buf.out(), str, indent);
        } else {
            buf.format("%s", StringUtil.indent(str, indent));
        }
    }

    public static void indent(StringBuilder buf, String str, String indent) {
        if (StringUtil.isEmpty(str)) {
            return;
        }
        if (StringUtil.isEmpty(indent = ObjectUtil.defaultIfNull(indent, ""))) {
            buf.append(str);
            return;
        }
        Matcher matcher = CRLF_PATTERN.matcher(str);
        int index = 0;
        while (matcher.find()) {
            if (index < matcher.start() && index > 0) {
                buf.append(indent);
            }
            buf.append(str, index, matcher.end());
            index = matcher.end();
        }
        if (index < str.length()) {
            if (index > 0) {
                buf.append(indent);
            }
            buf.append(str, index, str.length());
        }
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static String quoteIdentifier(String s) {
        int length = s.length();
        StringBuilder buff = new StringBuilder(length + 2);
        buff.append('\"');
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                buff.append(c);
            }
            buff.append(c);
        }
        return buff.append('\"').toString();
    }

    public static String escapeMetaDataPattern(String pattern) {
        if (pattern == null || pattern.length() == 0) {
            return pattern;
        }
        return StringUtil.replaceAll(pattern, "\\", "\\\\");
    }

    public static String replaceAll(String s, String before, String after) {
        int next = s.indexOf(before);
        if (next < 0) {
            return s;
        }
        StringBuilder buff = new StringBuilder(s.length() - before.length() + after.length());
        int index = 0;
        do {
            buff.append(s.substring(index, next)).append(after);
        } while ((next = s.indexOf(before, index = next + before.length())) >= 0);
        buff.append(s.substring(index));
        return buff.toString();
    }

    private static abstract class WordTokenizer {
        protected static final char UNDERSCORE = '_';

        private WordTokenizer() {
        }

        public String parse(String str) {
            if (StringUtil.isEmpty(str)) {
                return str;
            }
            int length = str.length();
            StringBuilder buffer = new StringBuilder(length);
            for (int index = 0; index < length; ++index) {
                char ch = str.charAt(index);
                if (Character.isWhitespace(ch)) continue;
                if (Character.isUpperCase(ch)) {
                    int wordIndex;
                    for (wordIndex = index + 1; wordIndex < length; ++wordIndex) {
                        char wordChar = str.charAt(wordIndex);
                        if (Character.isUpperCase(wordChar)) {
                            continue;
                        }
                        if (!Character.isLowerCase(wordChar)) break;
                        --wordIndex;
                        break;
                    }
                    if (wordIndex == length || wordIndex > index) {
                        index = this.parseUpperCaseWord(buffer, str, index, wordIndex);
                        continue;
                    }
                    index = this.parseTitleCaseWord(buffer, str, index);
                    continue;
                }
                if (Character.isLowerCase(ch)) {
                    index = this.parseLowerCaseWord(buffer, str, index);
                    continue;
                }
                if (Character.isDigit(ch)) {
                    index = this.parseDigitWord(buffer, str, index);
                    continue;
                }
                this.inDelimiter(buffer, ch);
            }
            return buffer.toString();
        }

        private int parseUpperCaseWord(StringBuilder buffer, String str, int index, int length) {
            char ch = str.charAt(index++);
            if (buffer.length() == 0) {
                this.startSentence(buffer, ch);
            } else {
                this.startWord(buffer, ch);
            }
            while (index < length) {
                ch = str.charAt(index);
                this.inWord(buffer, ch);
                ++index;
            }
            return index - 1;
        }

        private int parseLowerCaseWord(StringBuilder buffer, String str, int index) {
            char ch = str.charAt(index++);
            if (buffer.length() == 0) {
                this.startSentence(buffer, ch);
            } else {
                this.startWord(buffer, ch);
            }
            int length = str.length();
            while (index < length && Character.isLowerCase(ch = str.charAt(index))) {
                this.inWord(buffer, ch);
                ++index;
            }
            return index - 1;
        }

        private int parseTitleCaseWord(StringBuilder buffer, String str, int index) {
            char ch = str.charAt(index++);
            if (buffer.length() == 0) {
                this.startSentence(buffer, ch);
            } else {
                this.startWord(buffer, ch);
            }
            int length = str.length();
            while (index < length && Character.isLowerCase(ch = str.charAt(index))) {
                this.inWord(buffer, ch);
                ++index;
            }
            return index - 1;
        }

        private int parseDigitWord(StringBuilder buffer, String str, int index) {
            char ch = str.charAt(index++);
            if (buffer.length() == 0) {
                this.startDigitSentence(buffer, ch);
            } else {
                this.startDigitWord(buffer, ch);
            }
            int length = str.length();
            while (index < length && Character.isDigit(ch = str.charAt(index))) {
                this.inDigitWord(buffer, ch);
                ++index;
            }
            return index - 1;
        }

        protected boolean isDelimiter(char ch) {
            return !Character.isUpperCase(ch) && !Character.isLowerCase(ch) && !Character.isDigit(ch);
        }

        protected abstract void startSentence(StringBuilder var1, char var2);

        protected abstract void startWord(StringBuilder var1, char var2);

        protected abstract void inWord(StringBuilder var1, char var2);

        protected abstract void startDigitSentence(StringBuilder var1, char var2);

        protected abstract void startDigitWord(StringBuilder var1, char var2);

        protected abstract void inDigitWord(StringBuilder var1, char var2);

        protected abstract void inDelimiter(StringBuilder var1, char var2);
    }
}

