/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.tools;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.tinygroup.commons.tools.CollectionUtil;

public class EqualsUtil {
    public static boolean reflectionEquals(Object lhs, Object rhs) {
        return EqualsBuilder.reflectionEquals((Object)lhs, (Object)rhs);
    }

    public static boolean reflectionEquals(Object lhs, Object rhs, boolean testTransients) {
        return EqualsBuilder.reflectionEquals((Object)lhs, (Object)rhs, (boolean)testTransients);
    }

    public static boolean reflectionEquals(Object lhs, Object rhs, boolean testTransients, Class reflectUpToClass) {
        return EqualsBuilder.reflectionEquals((Object)lhs, (Object)rhs, (boolean)testTransients, (Class)reflectUpToClass);
    }

    public static boolean reflectionEquals(Object lhs, Object rhs, boolean testTransients, Class reflectUpToClass, String[] excludeFields) {
        return EqualsBuilder.reflectionEquals((Object)lhs, (Object)rhs, (boolean)testTransients, (Class)reflectUpToClass, (String[])excludeFields);
    }

    public static boolean reflectionEquals(Object lhs, Object rhs, String[] excludeFields) {
        return EqualsBuilder.reflectionEquals((Object)lhs, (Object)rhs, (String[])excludeFields);
    }

    public static boolean reflectionEquals(Object lhs, Object rhs, Collection excludeFields) {
        return EqualsBuilder.reflectionEquals((Object)lhs, (Object)rhs, (Collection)excludeFields);
    }

    public static boolean reflectionCompareEquals(Object lhs, Object rhs, String[] compareFields) {
        return EqualsUtil.reflectionCompareEquals(lhs, rhs, false, null, compareFields);
    }

    public static boolean reflectionCompareEquals(Object lhs, Object rhs, Collection compareFields) {
        return EqualsUtil.reflectionCompareEquals(lhs, rhs, false, null, CollectionUtil.toNoNullStringArray(compareFields));
    }

    public static boolean reflectionCompareEquals(Object lhs, Object rhs, boolean testTransients, Class reflectUpToClass, String[] compareFields) {
        Class<?> testClass;
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        Class<?> lhsClass = lhs.getClass();
        Class<?> rhsClass = rhs.getClass();
        if (lhsClass.isInstance(rhs)) {
            testClass = lhsClass;
            if (!rhsClass.isInstance(lhs)) {
                testClass = rhsClass;
            }
        } else if (rhsClass.isInstance(lhs)) {
            testClass = rhsClass;
            if (!lhsClass.isInstance(rhs)) {
                testClass = lhsClass;
            }
        } else {
            return false;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        try {
            EqualsUtil.reflectionCompareAppend(lhs, rhs, testClass, equalsBuilder, testTransients, compareFields);
            while (testClass.getSuperclass() != null && testClass != reflectUpToClass) {
                testClass = testClass.getSuperclass();
                EqualsUtil.reflectionCompareAppend(lhs, rhs, testClass, equalsBuilder, testTransients, compareFields);
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return equalsBuilder.isEquals();
    }

    private static void reflectionCompareAppend(Object lhs, Object rhs, Class clazz, EqualsBuilder builder, boolean useTransients, String[] compareFields) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        List<String> compareFieldList = compareFields != null ? Arrays.asList(compareFields) : Collections.EMPTY_LIST;
        AccessibleObject.setAccessible(fields, true);
        for (int i = 0; i < fields.length && builder.isEquals(); ++i) {
            AccessibleObject f = fields[i];
            if (!compareFieldList.contains(((Field)f).getName()) || ((Field)f).getName().indexOf(36) != -1 || !useTransients && Modifier.isTransient(((Field)f).getModifiers()) || Modifier.isStatic(((Field)f).getModifiers())) continue;
            try {
                builder.append(((Field)f).get(lhs), ((Field)f).get(rhs));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new InternalError("Unexpected IllegalAccessException");
            }
        }
    }
}

