/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.tools;

import java.util.LinkedHashMap;
import java.util.Map;
import org.tinygroup.commons.tools.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationAttributes
extends LinkedHashMap<String, Object> {
    public AnnotationAttributes() {
    }

    public AnnotationAttributes(int initialCapacity) {
        super(initialCapacity);
    }

    public AnnotationAttributes(Map<String, Object> map) {
        super(map);
    }

    public static AnnotationAttributes fromMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        if (map instanceof AnnotationAttributes) {
            return (AnnotationAttributes)map;
        }
        return new AnnotationAttributes(map);
    }

    public String getString(String attributeName) {
        return this.doGet(attributeName, String.class);
    }

    public String[] getStringArray(String attributeName) {
        return this.doGet(attributeName, String[].class);
    }

    public boolean getBoolean(String attributeName) {
        return this.doGet(attributeName, Boolean.class);
    }

    public <N extends Number> N getNumber(String attributeName) {
        return (N)this.doGet(attributeName, Integer.class);
    }

    public <E extends Enum<?>> E getEnum(String attributeName) {
        return (E)this.doGet(attributeName, Enum.class);
    }

    public <T> Class<? extends T> getClass(String attributeName) {
        return this.doGet(attributeName, Class.class);
    }

    public Class<?>[] getClassArray(String attributeName) {
        return this.doGet(attributeName, Class[].class);
    }

    public AnnotationAttributes getAnnotation(String attributeName) {
        return this.doGet(attributeName, AnnotationAttributes.class);
    }

    public AnnotationAttributes[] getAnnotationArray(String attributeName) {
        return this.doGet(attributeName, AnnotationAttributes[].class);
    }

    private <T> T doGet(String attributeName, Class<T> expectedType) {
        Assert.hasText(attributeName, "attributeName must not be null or empty");
        Object value = this.get(attributeName);
        Assert.assertNotNull(value, String.format("Attribute '%s' not found", attributeName), new Object[0]);
        Assert.isAssignable(expectedType, value.getClass(), String.format("Attribute '%s' is of type [%s], but [%s] was expected. Cause: ", attributeName, value.getClass().getSimpleName(), expectedType.getSimpleName()));
        return (T)value;
    }
}

