/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.match;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.commons.tools.StringEscapeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPathStringMatcher {
    private static final Pattern GLOB_PATTERN = Pattern.compile("\\?|\\*|\\{([^/]+?)\\}");
    private static final String DEFAULT_VARIABLE_PATTERN = "([^/]*?)";
    private final Pattern pattern;
    private String str;
    private final List<String> variableNames = new LinkedList<String>();
    private final Map<String, String> uriTemplateVariables = new HashMap<String, String>();

    public AntPathStringMatcher(String pattern, String str) {
        this.str = str;
        this.pattern = this.createPattern(pattern);
    }

    private Pattern createPattern(String pattern) {
        StringBuilder patternBuilder = new StringBuilder();
        Matcher m = GLOB_PATTERN.matcher(pattern);
        int end = 0;
        while (m.find()) {
            patternBuilder.append(this.quote(pattern, end, m.start()));
            String match = m.group();
            if ("?".equals(match)) {
                patternBuilder.append('.');
            } else if ("*".equals(match)) {
                patternBuilder.append(".*");
            } else if (match.startsWith("{") && match.endsWith("}")) {
                int colonIdx = match.indexOf(58);
                if (colonIdx == -1) {
                    patternBuilder.append(DEFAULT_VARIABLE_PATTERN);
                    this.variableNames.add(m.group(1));
                } else {
                    String variablePattern = match.substring(colonIdx + 1, match.length() - 1);
                    patternBuilder.append('(');
                    patternBuilder.append(variablePattern);
                    patternBuilder.append(')');
                    String variableName = match.substring(1, colonIdx);
                    this.variableNames.add(variableName);
                }
            }
            end = m.end();
        }
        patternBuilder.append(this.quote(pattern, end, pattern.length()));
        return Pattern.compile(patternBuilder.toString());
    }

    private String quote(String s, int start, int end) {
        if (start == end) {
            return "";
        }
        return Pattern.quote(s.substring(start, end));
    }

    public boolean matches() {
        Matcher matcher = this.pattern.matcher(this.str);
        if (matcher.matches()) {
            if (this.uriTemplateVariables != null) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String name = this.variableNames.get(i - 1);
                    String value = StringEscapeUtil.unescapeURL(matcher.group(i));
                    this.uriTemplateVariables.put(name, value);
                }
            }
            return true;
        }
        return false;
    }

    public List<String> getVariableNames() {
        return this.variableNames;
    }

    public Map<String, String> getUriTemplateVariables() {
        return this.uriTemplateVariables;
    }
}

