/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    private byte[] buffer;
    private int index;
    private int limit;
    private int mark;
    private boolean closed;

    public ByteArrayInputStream(byte[] data) {
        this(data, 0, data.length);
    }

    public ByteArrayInputStream(byte[] data, int offset, int length) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset + length > data.length || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer = data;
        this.index = offset;
        this.limit = offset + length;
        this.mark = offset;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.index >= this.limit) {
            return -1;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    public int read(byte[] data, int offset, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset + length > data.length || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.index >= this.limit) {
            return -1;
        }
        if (length > this.limit - this.index) {
            length = this.limit - this.index;
        }
        System.arraycopy(this.buffer, this.index, data, offset, length);
        this.index += length;
        return length;
    }

    public long skip(long amount) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (amount <= 0L) {
            return 0L;
        }
        if (amount > (long)(this.limit - this.index)) {
            amount = this.limit - this.index;
        }
        this.index += (int)amount;
        return amount;
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        return this.limit - this.index;
    }

    public void close() {
        this.closed = true;
    }

    public void mark(int readLimit) {
        this.mark = this.index;
    }

    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.index = this.mark;
    }

    public boolean markSupported() {
        return true;
    }
}

