/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.collection;

import org.tinygroup.commons.tools.BasicConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntHashMap<T> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry<T>[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public IntHashMap() {
        this(16, 0.75f);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[capacity];
        this.threshold = (int)((float)capacity * loadFactor);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsKey(int key) {
        Entry<T>[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<T> e = tab[index];
        while (e != null) {
            if (e.hash == hash) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        Entry<T>[] tab = this.table;
        boolean valueIsNull = value == null;
        int i = tab.length;
        while (i-- > 0) {
            Entry<T> e = tab[i];
            while (e != null) {
                if (valueIsNull ? e.value == null : value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public T get(int key) {
        Entry<T>[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<T> e = tab[index];
        while (e != null) {
            if (e.hash == hash) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public T put(int key, T value) {
        Entry<T>[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<T> e = tab[index];
        while (e != null) {
            if (e.hash == hash) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry<T>(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    public T remove(int key) {
        Entry<T>[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<T> e = tab[index];
        Entry<T> prev = null;
        while (e != null) {
            if (e.hash == hash) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public void clear() {
        Entry<T>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public int[] keys() {
        if (this.count == 0) {
            return BasicConstant.EMPTY_INT_ARRAY;
        }
        int[] keys = new int[this.count];
        int index = 0;
        Entry<T>[] arr$ = this.table;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Entry<T> element;
            Entry<T> entry = element = arr$[i$];
            while (entry != null) {
                keys[index++] = entry.key;
                entry = entry.next;
            }
        }
        return keys;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        int[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            T value = this.get(key);
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(key).append('=').append((Object)(value == this ? "(this Map)" : value));
        }
        buffer.append('}');
        return buffer.toString();
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry<T>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<T> old = oldMap[i];
            while (old != null) {
                Entry<T> e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    protected int getCapacity() {
        return this.table.length;
    }

    protected int getThreshold() {
        return this.threshold;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry<T> {
        protected int hash;
        protected int key;
        protected T value;
        protected Entry<T> next;

        protected Entry(int hash, int key, T value, Entry<T> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

