/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.chineseanalyzer;

import java.io.Reader;
import java.util.Collection;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.util.Version;
import org.tinygroup.chineseanalyzer.ChineseTokenStream;
import org.tinygroup.stopword.StopWordManager;

public class ChineseAnalyzer
extends Analyzer {
    private StopWordManager stopWordManager;

    public StopWordManager getStopWordManager() {
        return this.stopWordManager;
    }

    public void setStopWordManager(StopWordManager stopWordManager) {
        this.stopWordManager = stopWordManager;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        ChineseTokenStream source = new ChineseTokenStream(reader);
        if (this.stopWordManager != null) {
            CharArraySet stopWords = new CharArraySet(Version.LUCENE_CURRENT, (Collection)this.stopWordManager.getStopWords(), true);
            StopFilter result = new StopFilter(Version.LUCENE_CURRENT, (TokenStream)source, stopWords);
            return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)source);
    }
}

