/**
 * Copyright (c) 2012-2016, www.tinygroup.org (luo_guo@icloud.com).
 *
 *  Licensed under the GPL, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.gnu.org/licenses/gpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.tinygroup.chineseanalyzer;

import org.apache.lucene.analysis.Analyzer;

import java.io.Reader;

/**
 * 基于TinySeg的Lucene的分析器扩展
 *
 * @author yancheng11334
 */
public class ChineseAnalyzer extends Analyzer {


    protected TokenStreamComponents createComponents(String fieldName,
                                                     Reader reader) {
        return new TokenStreamComponents(new ChineseTokenStream(reader));
    }

}
