/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.chineseanalyzer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.tiny.seg.ChineseParser;
import org.tinygroup.beancontainer.BeanContainerFactory;

public class ChineseTokenStream
extends Tokenizer {
    private ChineseParserWrapper wrapper = null;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

    protected ChineseTokenStream(Reader input) {
        super(input);
        this.wrapper = new ChineseParserWrapper(input);
    }

    public void reset() throws IOException {
        super.reset();
        this.wrapper.reset();
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        ChineseWord word = this.wrapper.next();
        if (word != null) {
            this.termAtt.copyBuffer(word.getSource(), word.getSourceOffset(), word.getLength());
            this.offsetAtt.setOffset(word.getStartOffset(), word.getEndOffset());
            this.typeAtt.setType("word");
            return true;
        }
        this.end();
        return false;
    }

    class ChineseWord {
        private char[] source;
        private int sourceOffset;
        private int startOffset;
        private int length;
        private int index;

        public ChineseWord(char[] source, int sourceOffset, int startOffset, int length, int index) {
            this.source = source;
            this.sourceOffset = sourceOffset;
            this.startOffset = startOffset;
            this.length = length;
            this.index = index;
        }

        public char[] getSource() {
            return this.source;
        }

        public int getSourceOffset() {
            return this.sourceOffset;
        }

        public int getLength() {
            return this.length;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.startOffset + this.getLength();
        }

        public int getIndex() {
            return this.index;
        }
    }

    class ChineseParserWrapper {
        private BufferedReader reader = null;
        private String buffer = null;
        private ChineseParser parser = null;
        private int index = 0;
        private int offset = 0;
        private Queue<ChineseWord> words = null;

        public ChineseParserWrapper(Reader input) {
            this.reader = new BufferedReader(input);
            this.parser = (ChineseParser)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("chineseParser");
        }

        private void init() throws IOException {
            this.words = new LinkedList<ChineseWord>();
            while ((this.buffer = this.reader.readLine()) != null) {
                ArrayList result = new ArrayList();
                this.parser.segmentWordMax(this.buffer, result);
                int sourceOffset = 0;
                char[] source = this.buffer.toCharArray();
                for (String s : result) {
                    int length = s.toCharArray().length;
                    ChineseWord word = new ChineseWord(source, sourceOffset, this.offset, length, this.index);
                    this.words.add(word);
                    ++this.index;
                    sourceOffset += length;
                    this.offset += length;
                }
            }
        }

        public void reset() throws IOException {
            if (this.reader.markSupported()) {
                this.reader.mark(0);
            }
            this.reader.reset();
            this.buffer = null;
            this.index = 0;
            this.offset = 0;
            this.words = null;
        }

        public ChineseWord next() throws IOException {
            if (this.words == null) {
                this.init();
            }
            return this.words.poll();
        }
    }
}

