/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.engine.resolver;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResourceItem;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public class TestEngineTemplateResource
implements ITemplateResource {
    private final ITestResource resource;
    private final String characterEncoding;

    public TestEngineTemplateResource(ITestResource resource, String characterEncoding) {
        Validate.notNull((Object)resource, (String)"Resource cannot be null");
        this.resource = resource;
        this.characterEncoding = characterEncoding;
    }

    public String getDescription() {
        return this.resource.getName();
    }

    public String getBaseName() {
        return null;
    }

    public boolean exists() {
        return true;
    }

    public Reader reader() throws IOException {
        if (!(this.resource instanceof ITestResourceItem)) {
            throw new TestEngineExecutionException("Test specifies an input \"" + this.resource.getName() + "\" which is a container, not an item (maybe a folder?)");
        }
        String input = ((ITestResourceItem)this.resource).readAsText();
        if (input == null) {
            throw new FileNotFoundException(String.format("Test resource \"%s\" does not exist", this.resource.getName()));
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input.getBytes(this.characterEncoding));
        if (!StringUtils.isEmptyOrWhitespace((String)this.characterEncoding)) {
            return new InputStreamReader((InputStream)inputStream, this.characterEncoding);
        }
        return new InputStreamReader(inputStream);
    }

    public ITemplateResource relative(String relativeLocation) {
        throw new TemplateInputException(String.format("Cannot create relative resource for test resource \"%s\"", this.resource.getName()));
    }
}

