/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.util;

public final class EscapeUtils {
    private static final char ESCAPE_PREFIX = '\\';
    private static final char ESCAPE_UHEXA_PREFIX2 = 'u';
    private static char[] HEXA_CHARS_UPPER = "0123456789ABCDEF".toCharArray();
    private static char[] HEXA_CHARS_LOWER = "0123456789abcdef".toCharArray();

    static int parseIntFromReference(String text, int start, int end, int radix) {
        int result = 0;
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            int n = -1;
            for (int j = 0; j < HEXA_CHARS_UPPER.length; ++j) {
                if (c != HEXA_CHARS_UPPER[j] && c != HEXA_CHARS_LOWER[j]) continue;
                n = j;
                break;
            }
            result = radix * result + n;
        }
        return result;
    }

    public static String unescapeUnicode(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder strBuilder = null;
        boolean offset = false;
        int max = text.length();
        int readOffset = 0;
        int referenceOffset = 0;
        for (int i = 0; i < max; ++i) {
            char c = text.charAt(i);
            if (c != '\\' || i + 1 >= max) continue;
            int codepoint = -1;
            if (c == '\\') {
                char c1 = text.charAt(i + 1);
                if (c1 == 'u') {
                    char cf;
                    char cf2;
                    int f;
                    for (f = i + 2; f < max && (cf2 = text.charAt(f)) == 'u'; ++f) {
                    }
                    int s = f;
                    while (f < s + 4 && f < max && ((cf = text.charAt(f)) >= '0' && cf <= '9' || cf >= 'A' && cf <= 'F' || cf >= 'a' && cf <= 'f')) {
                        ++f;
                    }
                    if (f - s < 4) {
                        ++i;
                        continue;
                    }
                    codepoint = EscapeUtils.parseIntFromReference(text, s, f, 16);
                    referenceOffset = f - 1;
                } else {
                    if (c1 == '\\' && i + 2 < max && text.charAt(i + 2) == 'u') {
                        if (strBuilder == null) {
                            strBuilder = new StringBuilder(max + 5);
                        }
                        if (i - readOffset > 0) {
                            strBuilder.append(text, readOffset, i);
                        }
                        strBuilder.append('\\');
                        readOffset = i + 2;
                        ++i;
                        continue;
                    }
                    ++i;
                    continue;
                }
            }
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max + 5);
            }
            if (i - readOffset > 0) {
                strBuilder.append(text, readOffset, i);
            }
            i = referenceOffset;
            readOffset = i + 1;
            if (codepoint > 65535) {
                strBuilder.append(Character.toChars(codepoint));
                continue;
            }
            strBuilder.append((char)codepoint);
        }
        if (strBuilder == null) {
            return text;
        }
        if (max - readOffset > 0) {
            strBuilder.append(text, readOffset, max);
        }
        return strBuilder.toString();
    }

    private EscapeUtils() {
    }
}

