/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.engine.resolver;

import java.util.Map;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.cache.AlwaysValidCacheEntryValidity;
import org.thymeleaf.cache.ICacheEntryValidity;
import org.thymeleaf.cache.NonCacheableCacheEntryValidity;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolution;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.testing.templateengine.engine.TestExecutor;
import org.thymeleaf.testing.templateengine.engine.resolver.TestEngineTemplateResource;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestEngineTemplateResolver
implements ITemplateResolver {
    public static final String TEST_TEMPLATE_CONVERSION_CHARSET = "UTF-8";
    private String name = this.getClass().getName();
    private Integer order = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public TemplateResolution resolveTemplate(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        Validate.notNull((Object)configuration, (String)"Configuration cannot be null");
        ITest test = TestExecutor.getThreadTest();
        String testName = TestExecutor.getThreadTestName();
        Map<String, TemplateMode> additionalTemplateModes = test.getAdditionalTemplateModes();
        TemplateMode templateMode = additionalTemplateModes != null && additionalTemplateModes.containsKey(template) ? additionalTemplateModes.get(template) : test.getTemplateMode();
        if (templateMode == null) {
            throw new TestEngineExecutionException("Template mode is null for test \"" + testName + "\", which is forbidden");
        }
        ITestResource input = test.getInput();
        if (input == null) {
            throw new TestEngineExecutionException("Input is null for test \"" + testName + "\", which is forbidden");
        }
        ITestResource testResource = testName.equals(template) ? test.getInput() : (test.getAdditionalInputs() != null ? test.getAdditionalInputs().get(template) : null);
        if (testResource == null) {
            return null;
        }
        TestEngineTemplateResource templateResource = new TestEngineTemplateResource(testResource, TEST_TEMPLATE_CONVERSION_CHARSET);
        AlwaysValidCacheEntryValidity validity = test.isInputCacheable() ? AlwaysValidCacheEntryValidity.INSTANCE : NonCacheableCacheEntryValidity.INSTANCE;
        return new TemplateResolution((ITemplateResource)templateResource, true, templateMode, false, (ICacheEntryValidity)validity);
    }
}

