/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.engine.resolver;

import java.util.Locale;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.messageresolver.AbstractMessageResolver;
import org.thymeleaf.messageresolver.StandardMessageResolver;
import org.thymeleaf.testing.templateengine.engine.TestExecutor;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.messages.ITestMessages;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestEngineMessageResolver
extends AbstractMessageResolver {
    private final StandardMessageResolver standardMessageResolver = new StandardMessageResolver();

    public String resolveMessage(ITemplateContext context, Class<?> origin, String key, Object[] messageParameters) {
        Validate.notNull((Object)context.getLocale(), (String)"Locale in context cannot be null");
        Validate.notNull((Object)key, (String)"Message key cannot be null");
        Locale locale = context.getLocale();
        String message = null;
        ITest test = TestExecutor.getThreadTest();
        ITestMessages messages = test.getMessages();
        if (messages == null) {
            throw new TestEngineExecutionException("Cannot resolve messages for test \"" + TestExecutor.getThreadTestName() + "\", test " + "messages object is null.");
        }
        message = messages.computeMessage(locale, key, messageParameters);
        if (message != null) {
            return message;
        }
        if (origin != null && (message = this.standardMessageResolver.resolveMessage(null, origin, key, messageParameters)) != null) {
            return message;
        }
        return null;
    }

    public String createAbsentMessageRepresentation(ITemplateContext context, Class<?> origin, String key, Object[] messageParameters) {
        Validate.notNull((Object)key, (String)"Message key cannot be null");
        if (context.getLocale() != null) {
            return "??" + key + "_" + context.getLocale().toString() + "??";
        }
        return "??" + key + "_" + "??";
    }
}

