/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.attoparser.AttoParseException;
import org.attoparser.IAttoHandler;
import org.attoparser.markup.MarkupAttoParser;
import org.attoparser.markup.html.trace.TracingDetailedHtmlAttoHandler;
import org.attoparser.markup.trace.TraceEvent;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultCompareUtils {
    private static final AttributeEventComparator ATTRIBUTE_EVENT_COMPARATOR = new AttributeEventComparator();
    private static final MarkupAttoParser PARSER = new MarkupAttoParser();
    private static final Set<String> BLOCK_ELEMENTS = new HashSet<String>(Arrays.asList("address", "article", "aside", "audio", "blockquote", "canvas", "dd", "div", "dl", "dt", "fieldset", "figcaption", "figure", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "header", "hgroup", "hr", "li", "noscript", "ol", "option", "output", "p", "pre", "section", "table", "tbody", "tfoot", "tr", "td", "th", "ul", "video"));
    private static final Set<String> BLOCK_CONTAINER_ELEMENTS = new HashSet<String>(Arrays.asList("address", "article", "aside", "div", "dl", "fieldset", "footer", "form", "header", "hgroup", "noscript", "ol", "section", "table", "tbody", "tr", "tfoot", "ul"));

    public static ResultComparison compareResults(String expected, String actual, boolean lenient) {
        Validate.notNull((Object)expected, (String)"Expected result cannot be null");
        Validate.notNull((Object)actual, (String)"Actual result cannot be null");
        TracingDetailedHtmlAttoHandler expectedHandler = new TracingDetailedHtmlAttoHandler();
        TracingDetailedHtmlAttoHandler actualHandler = new TracingDetailedHtmlAttoHandler();
        try {
            PARSER.parse(expected, (IAttoHandler)expectedHandler);
            PARSER.parse(actual, (IAttoHandler)actualHandler);
        }
        catch (AttoParseException e) {
            throw new TestEngineExecutionException("Error while trying to compare results", e);
        }
        List<TraceEvent> expectedTrace = lenient ? ResultCompareUtils.normalizeTrace(expectedHandler.getTrace()) : expectedHandler.getTrace();
        List<TraceEvent> actualTrace = lenient ? ResultCompareUtils.normalizeTrace(actualHandler.getTrace()) : actualHandler.getTrace();
        int actualTraceSize = actualTrace.size();
        int expectedTraceSize = expectedTrace.size();
        for (int i = 0; i < actualTraceSize; ++i) {
            boolean itemMatches;
            TraceEvent expectedTraceItem;
            TraceEvent actualTraceItem = actualTrace.get(i);
            TraceEvent traceEvent = expectedTraceItem = expectedTraceSize > i ? expectedTrace.get(i) : null;
            if (expectedTraceItem == null) {
                int[] actualFragmentReportSizes = ResultCompareUtils.computeErrorMessageLength(actualTrace, i, actual);
                int[] expectedFragmentReportSizes = new int[]{20, 0};
                String actualFragment = ResultCompareUtils.getFragmentSurrounding(actual, actualTraceItem.getLine(), actualTraceItem.getCol(), actualFragmentReportSizes[0], actualFragmentReportSizes[1]);
                String expectedFragment = ResultCompareUtils.getFragmentSurrounding(expected, Integer.MAX_VALUE, Integer.MAX_VALUE, expectedFragmentReportSizes[0], expectedFragmentReportSizes[1]);
                String explanation = ResultCompareUtils.createExplanation(actualFragment, actualTraceItem.getLine(), actualTraceItem.getCol(), expectedFragment);
                return new ResultComparison(false, explanation);
            }
            TraceEvent comparableActualTraceItem = ResultCompareUtils.compressWhitespaceIfText(actualTraceItem);
            TraceEvent comparableExpectedTraceItem = ResultCompareUtils.compressWhitespaceIfText(expectedTraceItem);
            boolean bl = itemMatches = lenient ? comparableActualTraceItem.matchesTypeAndContent(comparableExpectedTraceItem) : actualTraceItem.equals((Object)expectedTraceItem);
            if (itemMatches) continue;
            int[] actualFragmentReportSizes = ResultCompareUtils.computeErrorMessageLength(actualTrace, i, actual);
            int[] expectedFragmentReportSizes = ResultCompareUtils.computeErrorMessageLength(expectedTrace, i, expected);
            String actualFragment = ResultCompareUtils.getFragmentSurrounding(actual, actualTraceItem.getLine(), actualTraceItem.getCol(), actualFragmentReportSizes[0], actualFragmentReportSizes[1]);
            String expectedFragment = ResultCompareUtils.getFragmentSurrounding(expected, expectedTraceItem.getLine(), expectedTraceItem.getCol(), expectedFragmentReportSizes[0], expectedFragmentReportSizes[1]);
            String explanation = ResultCompareUtils.createExplanation(actualFragment, actualTraceItem.getLine(), actualTraceItem.getCol(), expectedFragment);
            return new ResultComparison(false, explanation);
        }
        return new ResultComparison(true, "OK");
    }

    private static List<TraceEvent> normalizeTrace(List<TraceEvent> trace) {
        String lastOpenElementName = null;
        String lastClosedElementName = null;
        boolean lastIsWhiteSpace = false;
        ArrayList<TraceEvent> newTrace = new ArrayList<TraceEvent>();
        ArrayList<TraceEvent> currentAttributeList = new ArrayList<TraceEvent>();
        for (TraceEvent event : trace) {
            String elementName;
            String eventType = event.getType();
            if (!(currentAttributeList.isEmpty() || "A".equals(eventType) || "IW".equals(eventType))) {
                Collections.sort(currentAttributeList, ATTRIBUTE_EVENT_COMPARATOR);
                newTrace.addAll(currentAttributeList);
                currentAttributeList.clear();
                lastIsWhiteSpace = false;
            }
            if (newTrace.size() == 2 && !"DT".equals(eventType) && !"X".equals(eventType) && !"DE".equals(eventType) && lastIsWhiteSpace) {
                newTrace.remove(newTrace.size() - 1);
                lastIsWhiteSpace = false;
            }
            if ("T".equals(eventType)) {
                String text = event.getContent()[0];
                newTrace.add(event);
                if (ResultCompareUtils.isAllWhitespace(text)) {
                    lastIsWhiteSpace = true;
                    continue;
                }
                lastOpenElementName = null;
                lastClosedElementName = null;
                continue;
            }
            if ("IW".equals(eventType)) continue;
            if ("A".equals(eventType)) {
                currentAttributeList.add(event);
                continue;
            }
            if ("CEE".equals(eventType) || "SEE".equals(eventType)) {
                lastClosedElementName = event.getContent()[0].toLowerCase();
                lastOpenElementName = null;
                newTrace.add(event);
                lastIsWhiteSpace = false;
                continue;
            }
            if ("OES".equals(eventType) || "SES".equals(eventType)) {
                elementName = event.getContent()[0].toLowerCase();
                if (lastClosedElementName != null && BLOCK_ELEMENTS.contains(lastClosedElementName) && BLOCK_ELEMENTS.contains(elementName)) {
                    if (lastIsWhiteSpace) {
                        newTrace.remove(newTrace.size() - 1);
                        lastIsWhiteSpace = false;
                    }
                } else if (lastOpenElementName != null && BLOCK_CONTAINER_ELEMENTS.contains(lastOpenElementName) && BLOCK_ELEMENTS.contains(elementName) && lastIsWhiteSpace) {
                    newTrace.remove(newTrace.size() - 1);
                    lastIsWhiteSpace = false;
                }
                if ("SES".equals(eventType)) {
                    lastOpenElementName = null;
                    lastClosedElementName = event.getContent()[0].toLowerCase();
                } else {
                    lastOpenElementName = event.getContent()[0].toLowerCase();
                    lastClosedElementName = null;
                }
                newTrace.add(event);
                lastIsWhiteSpace = false;
                continue;
            }
            if ("CES".equals(eventType)) {
                elementName = event.getContent()[0].toLowerCase();
                if (lastClosedElementName != null && BLOCK_ELEMENTS.contains(lastClosedElementName) && BLOCK_CONTAINER_ELEMENTS.contains(elementName) && lastIsWhiteSpace) {
                    newTrace.remove(newTrace.size() - 1);
                    lastIsWhiteSpace = false;
                }
                lastOpenElementName = null;
                lastClosedElementName = event.getContent()[0].toLowerCase();
                newTrace.add(event);
                lastIsWhiteSpace = false;
                continue;
            }
            if ("DE".equals(eventType)) {
                String text;
                TraceEvent lastEvent;
                TraceEvent traceEvent = lastEvent = newTrace.size() > 2 ? (TraceEvent)newTrace.get(newTrace.size() - 1) : null;
                if (lastEvent != null && "T".equals(lastEvent.getType()) && ResultCompareUtils.isAllWhitespace(text = lastEvent.getContent()[0])) {
                    newTrace.remove(newTrace.size() - 1);
                }
                newTrace.add(event);
                lastIsWhiteSpace = false;
                continue;
            }
            if ("OEE".equals(eventType)) {
                lastClosedElementName = null;
                newTrace.add(event);
                lastIsWhiteSpace = false;
                continue;
            }
            lastOpenElementName = null;
            lastClosedElementName = null;
            newTrace.add(event);
            lastIsWhiteSpace = false;
        }
        return newTrace;
    }

    private static TraceEvent compressWhitespaceIfText(TraceEvent event) {
        String eventType = event.getType();
        if (!"T".equals(eventType)) {
            return event;
        }
        String text = event.getContent()[0];
        StringBuilder strBuilder = new StringBuilder();
        boolean whitespace = false;
        int textLen = text.length();
        for (int i = 0; i < textLen; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                if (whitespace) continue;
                strBuilder.append(' ');
                whitespace = true;
                continue;
            }
            whitespace = false;
            strBuilder.append(c);
        }
        return new TraceEvent(event.getLine(), event.getCol(), event.getType(), new String[]{strBuilder.toString()});
    }

    private static boolean isAllWhitespace(String text) {
        int textLen = text.length();
        for (int i = 0; i < textLen; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private static String getFragmentSurrounding(String text, int line, int col, int before, int after) {
        int pos;
        int textLen = text.length();
        int cline = 1;
        int ccol = 1;
        for (pos = 0; pos < textLen && (cline < line || ccol < col); ++pos) {
            char c = text.charAt(pos);
            if (c == '\n') {
                ++cline;
                ccol = 1;
                continue;
            }
            ++ccol;
        }
        if (pos >= textLen) {
            pos = textLen - 1;
        }
        int startPos = Math.max(0, pos - before);
        int endPos = Math.min(textLen, pos + after);
        return new String(text.substring(startPos, endPos));
    }

    public static String createExplanation(String actualFragment, int actualLine, int actualCol, String expectedFragment) {
        return "Actual result does not match expected result.\nObtained:\n[" + actualFragment + "]\n" + "at line " + actualLine + " col " + actualCol + ", but " + "expected:\n[" + expectedFragment + "]";
    }

    private static int[] computeErrorMessageLength(List<TraceEvent> trace, int position, String result) {
        TraceEvent eventItem = trace.get(position);
        if ("T".equals(eventItem.getType())) {
            String[] contentArray = eventItem.getContent();
            if (contentArray == null || contentArray.length == 0) {
                return new int[]{20, 80};
            }
            String contentObj = eventItem.getContent()[0];
            if (contentObj == null || !(contentObj instanceof String)) {
                return new int[]{20, 80};
            }
            String content = contentObj;
            return new int[]{20, content.length() + 20};
        }
        if ("A".equals(eventItem.getType()) || "OES".equals(eventItem.getType()) || "SES".equals(eventItem.getType())) {
            int attributeLine = eventItem.getLine();
            int attributeCol = eventItem.getCol();
            int i = position;
            eventItem = trace.get(i);
            while (!"OES".equals(eventItem.getType()) && !"SES".equals(eventItem.getType()) && i > 0) {
                eventItem = trace.get(--i);
            }
            int elementLine = eventItem.getLine();
            int elementCol = eventItem.getCol();
            int beforeDistance = ResultCompareUtils.computeDistance(result, elementLine, elementCol, attributeLine, attributeCol);
            int afterDistance = 0;
            int lastAttributeLen = 0;
            eventItem = trace.get(++i);
            while ("A".equals(eventItem.getType()) && i < trace.size()) {
                int distance = ResultCompareUtils.computeDistance(result, attributeLine, attributeCol, eventItem.getLine(), eventItem.getCol());
                if (distance > afterDistance) {
                    afterDistance = distance;
                    lastAttributeLen = eventItem.getContent()[0].length() + (eventItem.getContent()[1] != null ? eventItem.getContent()[1].length() : 0) + (eventItem.getContent()[2] != null ? eventItem.getContent()[2].length() : 0);
                }
                eventItem = trace.get(++i);
            }
            return new int[]{beforeDistance + 20, afterDistance + lastAttributeLen + 80};
        }
        return new int[]{20, 80};
    }

    private static int computeDistance(String text, int lineFrom, int colFrom, int lineTo, int colTo) {
        char c;
        int i;
        int textLen = text.length();
        int startPos = 0;
        int endPos = 0;
        int line = 1;
        int col = 1;
        for (i = 0; i < textLen; ++i) {
            if (line == lineFrom && col == colFrom) {
                startPos = i;
                break;
            }
            c = text.charAt(i);
            if (c == '\n') {
                ++line;
                col = 1;
                continue;
            }
            ++col;
        }
        line = 1;
        col = 1;
        for (i = 0; i < textLen; ++i) {
            if (line == lineTo && col == colTo) {
                endPos = i;
                break;
            }
            c = text.charAt(i);
            if (c == '\n') {
                ++line;
                col = 1;
                continue;
            }
            ++col;
        }
        return endPos - startPos;
    }

    private ResultCompareUtils() {
    }

    public static class ResultComparison {
        private final boolean result;
        private final String explanation;

        public ResultComparison(boolean result, String explanation) {
            this.result = result;
            this.explanation = explanation;
        }

        public boolean getResult() {
            return this.result;
        }

        public String getExplanation() {
            return this.explanation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributeEventComparator
    implements Comparator<TraceEvent> {
        AttributeEventComparator() {
        }

        @Override
        public int compare(TraceEvent o1, TraceEvent o2) {
            String name2;
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            String name1 = o1.getContent().length > 0 ? o1.getContent()[0] : null;
            String string = name2 = o2.getContent().length > 0 ? o2.getContent()[0] : null;
            if (name1 == null) {
                return -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }
}

