/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.testable;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.testing.templateengine.context.ITestContext;
import org.thymeleaf.testing.templateengine.context.TestContext;
import org.thymeleaf.testing.templateengine.messages.ITestMessages;
import org.thymeleaf.testing.templateengine.messages.TestMessages;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.testable.AbstractTestable;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTest
extends AbstractTestable
implements ITest {
    public static String DEFAULT_TEMPLATE_MODE = "HTML5";
    public static IFragmentSpec DEFAULT_FRAGMENT_SPEC = null;
    public static boolean DEFAULT_INPUT_CACHEABLE = true;
    private ITestContext context = new TestContext();
    private ITestMessages messages = new TestMessages();
    private String templateMode = DEFAULT_TEMPLATE_MODE;
    private IFragmentSpec fragmentSpec = DEFAULT_FRAGMENT_SPEC;
    private ITestResource input = null;
    private boolean inputCacheable = DEFAULT_INPUT_CACHEABLE;
    private Map<String, ITestResource> additionalInputs = new HashMap<String, ITestResource>();

    protected AbstractTest() {
    }

    public void setContext(ITestContext context) {
        Validate.notNull((Object)context, (String)"Context cannot be null");
        this.context = context;
    }

    @Override
    public ITestContext getContext() {
        return this.context;
    }

    public void setMessages(ITestMessages messages) {
        Validate.notNull((Object)messages, (String)"Messages cannot be null");
        this.messages = messages;
    }

    @Override
    public ITestMessages getMessages() {
        return this.messages;
    }

    public void setTemplateMode(String templateMode) {
        this.templateMode = templateMode;
    }

    @Override
    public String getTemplateMode() {
        return this.templateMode;
    }

    @Override
    public boolean hasFragmentSpec() {
        return this.fragmentSpec != null;
    }

    public void setFragmentSpec(IFragmentSpec fragmentSpec) {
        this.fragmentSpec = fragmentSpec;
    }

    @Override
    public IFragmentSpec getFragmentSpec() {
        return this.fragmentSpec;
    }

    @Override
    public ITestResource getInput() {
        return this.input;
    }

    public void setInput(ITestResource input) {
        this.input = input;
    }

    @Override
    public Map<String, ITestResource> getAdditionalInputs() {
        return Collections.unmodifiableMap(this.additionalInputs);
    }

    public void setAdditionalInputs(Map<String, ITestResource> additionalInputs) {
        this.additionalInputs = new HashMap<String, ITestResource>(additionalInputs);
    }

    public void setAdditionalInput(String name, ITestResource resource) {
        this.additionalInputs.put(name, resource);
    }

    @Override
    public boolean isInputCacheable() {
        return this.inputCacheable;
    }

    public void setInputCacheable(boolean inputCacheale) {
        this.inputCacheable = inputCacheale;
    }
}

