/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.resource;

import java.io.InputStream;
import java.net.URL;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resource.AbstractTestResource;
import org.thymeleaf.testing.templateengine.resource.IClassPathTestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResourceItem;
import org.thymeleaf.testing.templateengine.util.ResourceUtils;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.Validate;

public final class ClassPathFileTestResource
extends AbstractTestResource
implements ITestResourceItem,
IClassPathTestResource {
    private final String characterEncoding;
    private final URL resourceURL;

    public ClassPathFileTestResource(String resourceName, String characterEncoding) {
        super(resourceName);
        Validate.notNull((Object)resourceName, (String)"Resource name cannot be null");
        Validate.notNull((Object)characterEncoding, (String)"Character encoding cannot be null");
        this.characterEncoding = characterEncoding;
        ClassLoader cl = ClassLoaderUtils.getClassLoader(ClassPathFileTestResource.class);
        this.resourceURL = cl.getResource(resourceName);
        if (this.resourceURL == null) {
            throw new TestEngineExecutionException("Error while reading classpath resource \"" + resourceName + "\". " + "Could not obtain resource as URL.");
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public URL getResourceURL() {
        return this.resourceURL;
    }

    public String readAsText() {
        try {
            InputStream is = this.resourceURL.openStream();
            return ResourceUtils.read(is, this.characterEncoding);
        }
        catch (TestEngineExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TestEngineExecutionException("Error reading class path resource: \"" + this.getName() + "\" from URL " + "\"" + this.resourceURL + "\"", e);
        }
    }
}

