/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.test.evaluator.field.defaultevaluators;

import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.thymeleaf.testing.templateengine.context.ITestContext;
import org.thymeleaf.testing.templateengine.context.ITestContextExpression;
import org.thymeleaf.testing.templateengine.context.OgnlTestContextExpression;
import org.thymeleaf.testing.templateengine.context.TestContext;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestEvaluatedField;
import org.thymeleaf.testing.templateengine.standard.test.evaluator.field.defaultevaluators.AbstractStandardTestFieldEvaluator;
import org.thymeleaf.testing.templateengine.util.MultiValueProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContextStandardTestFieldEvaluator
extends AbstractStandardTestFieldEvaluator {
    private static final String VAR_NAME_PREFIX_PARAM = "param.";
    private static final String VAR_NAME_PREFIX_REQUEST = "request.";
    private static final String VAR_NAME_PREFIX_SESSION = "session.";
    private static final String VAR_NAME_PREFIX_APPLICATION = "application.";
    public static final DefaultContextStandardTestFieldEvaluator INSTANCE = new DefaultContextStandardTestFieldEvaluator();
    public static final String LOCALE_PROPERTY_NAME = "locale";

    private DefaultContextStandardTestFieldEvaluator() {
        super(ITestContext.class);
    }

    @Override
    protected StandardTestEvaluatedField getValue(String executionId, String documentName, String fieldName, String fieldQualifier, String fieldValue) {
        if (fieldValue == null || fieldValue.trim().equals("")) {
            return StandardTestEvaluatedField.forDefaultValue(new TestContext());
        }
        MultiValueProperties properties = new MultiValueProperties();
        try {
            byte[] valueAsBytes = fieldValue.getBytes("ISO-8859-1");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(valueAsBytes);
            properties.load(inputStream);
        }
        catch (Throwable t) {
            throw new TestEngineExecutionException("Error while reading context specification", t);
        }
        TestContext testContext = new TestContext();
        for (Map.Entry<String, List<String>> entry : properties.entrySet()) {
            String varName = entry.getKey();
            List<String> varValue = entry.getValue();
            if (varName.equalsIgnoreCase(LOCALE_PROPERTY_NAME)) {
                DefaultContextStandardTestFieldEvaluator.checkForbiddenMultiValue(documentName, varName, varValue);
                testContext.setLocale(new Locale(varValue.get(0)));
                continue;
            }
            if (varName.startsWith(VAR_NAME_PREFIX_PARAM)) {
                int valueLen = varValue.size();
                ITestContextExpression[] expressions = new ITestContextExpression[valueLen];
                for (int i = 0; i < valueLen; ++i) {
                    expressions[i] = new OgnlTestContextExpression(varValue.get(i));
                }
                testContext.getRequestParameters().put(varName.substring(VAR_NAME_PREFIX_PARAM.length()), expressions);
                continue;
            }
            if (varName.startsWith(VAR_NAME_PREFIX_REQUEST)) {
                DefaultContextStandardTestFieldEvaluator.checkForbiddenMultiValue(documentName, varName, varValue);
                testContext.getRequestAttributes().put(varName.substring(VAR_NAME_PREFIX_REQUEST.length()), new OgnlTestContextExpression(varValue.get(0)));
                continue;
            }
            if (varName.startsWith(VAR_NAME_PREFIX_SESSION)) {
                DefaultContextStandardTestFieldEvaluator.checkForbiddenMultiValue(documentName, varName, varValue);
                testContext.getSessionAttributes().put(varName.substring(VAR_NAME_PREFIX_SESSION.length()), new OgnlTestContextExpression(varValue.get(0)));
                continue;
            }
            if (varName.startsWith(VAR_NAME_PREFIX_APPLICATION)) {
                DefaultContextStandardTestFieldEvaluator.checkForbiddenMultiValue(documentName, varName, varValue);
                testContext.getServletContextAttributes().put(varName.substring(VAR_NAME_PREFIX_APPLICATION.length()), new OgnlTestContextExpression(varValue.get(0)));
                continue;
            }
            DefaultContextStandardTestFieldEvaluator.checkForbiddenMultiValue(documentName, varName, varValue);
            testContext.getVariables().put(varName, new OgnlTestContextExpression(varValue.get(0)));
        }
        return StandardTestEvaluatedField.forSpecifiedValue(testContext);
    }

    private static void checkForbiddenMultiValue(String documentName, String varName, List<String> varValue) {
        if (varValue.size() > 1) {
            throw new TestEngineExecutionException("Variable \"" + varName + "\" in context for test \"" + documentName + "\" " + "cannot be multi-valued");
        }
    }
}

