/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.engine.resolver;

import java.util.Locale;
import org.thymeleaf.Arguments;
import org.thymeleaf.messageresolver.AbstractMessageResolver;
import org.thymeleaf.messageresolver.MessageResolution;
import org.thymeleaf.testing.templateengine.engine.TestExecutor;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.messages.ITestMessages;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.util.MessageResolutionUtils;
import org.thymeleaf.util.Validate;

public class TestMessageResolver
extends AbstractMessageResolver {
    public MessageResolution resolveMessage(Arguments arguments, String key, Object[] messageParameters) {
        this.checkInitialized();
        Validate.notNull((Object)arguments, (String)"Arguments cannot be null");
        Validate.notNull((Object)key, (String)"Key cannot be null");
        ITest test = TestExecutor.getThreadTest();
        Locale locale = arguments.getContext().getLocale();
        ITestMessages messages = test.getMessages();
        if (messages == null) {
            throw new TestEngineExecutionException("Cannot resolve messages for test \"" + TestExecutor.getThreadTestName() + "\", test " + "messages object is null.");
        }
        String message = messages.computeMessage(locale, key, messageParameters);
        if (message == null) {
            message = MessageResolutionUtils.getAbsentMessageRepresentation((String)key, (Locale)locale);
        }
        return new MessageResolution(message);
    }
}

