/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.context.web;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import ognl.Ognl;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.ProcessingContext;
import org.thymeleaf.context.WebContext;
import org.thymeleaf.testing.templateengine.context.IProcessingContextBuilder;
import org.thymeleaf.testing.templateengine.context.ITestContext;
import org.thymeleaf.testing.templateengine.context.ITestContextExpression;
import org.thymeleaf.testing.templateengine.engine.TestExecutor;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.messages.ITestMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebProcessingContextBuilder
implements IProcessingContextBuilder {
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final String REQUEST_PARAMS_PREFIX = "param";
    private static final String REQUEST_ATTRS_PREFIX = "request";
    private static final String SESSION_ATTRS_PREFIX = "session";
    private static final String SERVLETCONTEXT_ATTRS_PREFIX = "application";

    @Override
    public final IProcessingContext build(ITestContext testContext, ITestMessages testMessages) {
        if (testContext == null) {
            return null;
        }
        Locale locale = testContext.getLocale();
        if (locale == null) {
            locale = DEFAULT_LOCALE;
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        HashMap<String, Object[]> requestParameters = new HashMap<String, Object[]>();
        variables.put(REQUEST_PARAMS_PREFIX, requestParameters);
        HashMap<String, Object> requestAttributes = new HashMap<String, Object>();
        variables.put(REQUEST_ATTRS_PREFIX, requestAttributes);
        HashMap<String, Object> sessionAttributes = new HashMap<String, Object>();
        variables.put(SESSION_ATTRS_PREFIX, sessionAttributes);
        HashMap<String, Object> servletContextAttributes = new HashMap<String, Object>();
        variables.put(SERVLETCONTEXT_ATTRS_PREFIX, servletContextAttributes);
        for (Map.Entry<String, ITestContextExpression> entry : testContext.getVariables().entrySet()) {
            WebProcessingContextBuilder.resolve(entry.getKey(), entry.getValue(), variables, locale);
        }
        for (Map.Entry<String, ITestContextExpression> entry : testContext.getRequestParameters().entrySet()) {
            int firstPoint = entry.getKey().indexOf(46);
            String paramName = firstPoint == -1 ? entry.getKey() : entry.getKey().substring(0, firstPoint);
            String remainder = firstPoint == -1 ? "" : entry.getKey().substring(firstPoint);
            Object[] paramValues = new Object[((ITestContextExpression[])entry.getValue()).length];
            requestParameters.put(paramName, paramValues);
            int expressionsLen = ((ITestContextExpression[])entry.getValue()).length;
            for (int i = 0; i < expressionsLen; ++i) {
                WebProcessingContextBuilder.resolve("param." + paramName + "[" + i + "]" + remainder, ((ITestContextExpression[])entry.getValue())[i], variables, locale);
            }
        }
        for (Map.Entry<String, ITestContextExpression> entry : testContext.getRequestAttributes().entrySet()) {
            WebProcessingContextBuilder.resolve("request." + entry.getKey(), entry.getValue(), variables, locale);
        }
        for (Map.Entry<String, ITestContextExpression> entry : testContext.getSessionAttributes().entrySet()) {
            WebProcessingContextBuilder.resolve("session." + entry.getKey(), entry.getValue(), variables, locale);
        }
        for (Map.Entry<String, ITestContextExpression> entry : testContext.getServletContextAttributes().entrySet()) {
            WebProcessingContextBuilder.resolve("application." + entry.getKey(), entry.getValue(), variables, locale);
        }
        ServletContext servletContext = WebProcessingContextBuilder.createServletContext(servletContextAttributes);
        HttpSession httpSession = WebProcessingContextBuilder.createHttpSession(servletContext, sessionAttributes);
        HttpServletRequest request = WebProcessingContextBuilder.createHttpServletRequest(httpSession, requestAttributes, requestParameters, locale);
        HttpServletResponse response = WebProcessingContextBuilder.createHttpServletResponse();
        variables.remove(REQUEST_PARAMS_PREFIX);
        variables.remove(REQUEST_ATTRS_PREFIX);
        variables.remove(SESSION_ATTRS_PREFIX);
        variables.remove(SERVLETCONTEXT_ATTRS_PREFIX);
        this.doAdditionalVariableProcessing(testContext, testMessages, request, response, servletContext, locale, variables);
        WebContext context = new WebContext(request, response, servletContext, locale, variables);
        return new ProcessingContext((IContext)context);
    }

    protected void doAdditionalVariableProcessing(ITestContext testContext, ITestMessages testMessages, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Locale locale, Map<String, Object> variables) {
    }

    private static final HttpServletRequest createHttpServletRequest(HttpSession session, Map<String, Object> attributes, Map<String, Object[]> parameters, Locale locale) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/testing");
        Mockito.when((Object)request.getLocale()).thenReturn((Object)locale);
        Mockito.when((Object)request.getLocales()).thenReturn(new ObjectEnumeration<Locale>(Arrays.asList(locale)));
        Mockito.when((Object)request.getSession()).thenReturn((Object)session);
        Mockito.when((Object)request.getSession(Matchers.anyBoolean())).thenReturn((Object)session);
        Mockito.when((Object)request.getAttributeNames()).thenAnswer((Answer)new GetVariableNamesAnswer(attributes));
        Mockito.when((Object)request.getAttribute(Matchers.anyString())).thenAnswer((Answer)new GetAttributeAnswer(attributes));
        ((HttpServletRequest)Mockito.doAnswer((Answer)new SetAttributeAnswer(attributes)).when((Object)request)).setAttribute(Matchers.anyString(), Matchers.anyObject());
        Mockito.when((Object)request.getParameterNames()).thenAnswer((Answer)new GetVariableNamesAnswer(parameters));
        Mockito.when((Object)request.getParameterValues(Matchers.anyString())).thenAnswer((Answer)new GetParameterValuesAnswer(parameters));
        Mockito.when((Object)request.getParameterMap()).thenAnswer((Answer)new GetParameterMapAnswer(parameters));
        Mockito.when((Object)request.getParameter(Matchers.anyString())).thenAnswer((Answer)new GetParameterAnswer(parameters));
        return request;
    }

    private static final HttpSession createHttpSession(ServletContext context, Map<String, Object> attributes) {
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        Mockito.when((Object)session.getServletContext()).thenReturn((Object)context);
        Mockito.when((Object)session.getAttributeNames()).thenAnswer((Answer)new GetVariableNamesAnswer(attributes));
        Mockito.when((Object)session.getAttribute(Matchers.anyString())).thenAnswer((Answer)new GetAttributeAnswer(attributes));
        ((HttpSession)Mockito.doAnswer((Answer)new SetAttributeAnswer(attributes)).when((Object)session)).setAttribute(Matchers.anyString(), Matchers.anyObject());
        return session;
    }

    private static final HttpServletResponse createHttpServletResponse() {
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)response.encodeURL(Matchers.anyString())).thenAnswer((Answer)new EncodeUrlAnswer());
        return response;
    }

    private static final ServletContext createServletContext(Map<String, Object> attributes) {
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)servletContext.getAttributeNames()).thenAnswer((Answer)new GetVariableNamesAnswer(attributes));
        Mockito.when((Object)servletContext.getAttribute(Matchers.anyString())).thenAnswer((Answer)new GetAttributeAnswer(attributes));
        ((ServletContext)Mockito.doAnswer((Answer)new SetAttributeAnswer(attributes)).when((Object)servletContext)).setAttribute(Matchers.anyString(), Matchers.anyObject());
        return servletContext;
    }

    private static void resolve(String expression, ITestContextExpression contextExpression, Map<String, Object> variables, Locale locale) {
        try {
            Object result = contextExpression.evaluate(variables, locale);
            Object parsedExpression = Ognl.parseExpression((String)expression);
            Ognl.setValue((Object)parsedExpression, variables, (Object)result);
        }
        catch (Throwable t) {
            throw new TestEngineExecutionException("Exception while trying to evaluate expression \"" + expression + "\" on context for test \"" + TestExecutor.getThreadTestName() + "\"", t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EncodeUrlAnswer
    implements Answer<String> {
        public String answer(InvocationOnMock invocation) throws Throwable {
            return (String)invocation.getArguments()[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetParameterMapAnswer
    implements Answer<Map<String, String[]>> {
        private final Map<String, Object[]> values;

        public GetParameterMapAnswer(Map<String, Object[]> values) {
            this.values = values;
        }

        public Map<String, String[]> answer(InvocationOnMock invocation) throws Throwable {
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            for (Map.Entry<String, Object[]> valueEntry : this.values.entrySet()) {
                String parameterName = valueEntry.getKey();
                Object[] parameterValues = valueEntry.getValue();
                if (parameterValues == null) {
                    parameterMap.put(parameterName, null);
                    continue;
                }
                String[] parameterValuesArray = new String[parameterValues.length];
                for (int i = 0; i < parameterValuesArray.length; ++i) {
                    Object value = parameterValues[i];
                    parameterValuesArray[i] = value == null ? null : value.toString();
                }
                parameterMap.put(parameterName, parameterValuesArray);
            }
            return parameterMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetParameterAnswer
    implements Answer<String> {
        private final Map<String, Object[]> values;

        public GetParameterAnswer(Map<String, Object[]> values) {
            this.values = values;
        }

        public String answer(InvocationOnMock invocation) throws Throwable {
            String parameterName = (String)invocation.getArguments()[0];
            Object[] parameterValues = this.values.get(parameterName);
            if (parameterValues == null) {
                return null;
            }
            Object value = parameterValues[0];
            return value == null ? null : value.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetParameterValuesAnswer
    implements Answer<String[]> {
        private final Map<String, Object[]> values;

        public GetParameterValuesAnswer(Map<String, Object[]> values) {
            this.values = values;
        }

        public String[] answer(InvocationOnMock invocation) throws Throwable {
            String parameterName = (String)invocation.getArguments()[0];
            Object[] parameterValues = this.values.get(parameterName);
            if (parameterValues == null) {
                return null;
            }
            String[] parameterValuesArray = new String[parameterValues.length];
            for (int i = 0; i < parameterValuesArray.length; ++i) {
                Object value = parameterValues[i];
                parameterValuesArray[i] = value == null ? null : value.toString();
            }
            return parameterValuesArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetAttributeAnswer
    implements Answer<Object> {
        private final Map<String, Object> values;

        public SetAttributeAnswer(Map<String, Object> values) {
            this.values = values;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            String attributeName = (String)invocation.getArguments()[0];
            Object attributeValue = invocation.getArguments()[1];
            this.values.put(attributeName, attributeValue);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetAttributeAnswer
    implements Answer<Object> {
        private final Map<String, Object> values;

        public GetAttributeAnswer(Map<String, Object> values) {
            this.values = values;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            String attributeName = (String)invocation.getArguments()[0];
            return this.values.get(attributeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetVariableNamesAnswer
    implements Answer<Enumeration<?>> {
        private final Map<String, ?> values;

        public GetVariableNamesAnswer(Map<String, ?> values) {
            this.values = values;
        }

        public Enumeration<?> answer(InvocationOnMock invocation) throws Throwable {
            return new ObjectEnumeration<String>(this.values.keySet());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectEnumeration<T>
    implements Enumeration<T> {
        private final Iterator<T> iterator;

        public ObjectEnumeration(Collection<T> values) {
            this.iterator = values.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iterator.next();
        }
    }
}

