/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.web.webflux;

import java.nio.charset.Charset;
import java.security.Principal;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.thymeleaf.spring6.web.webflux.ISpringWebFluxWebApplication;
import org.thymeleaf.spring6.web.webflux.ISpringWebFluxWebExchange;
import org.thymeleaf.spring6.web.webflux.ISpringWebFluxWebRequest;
import org.thymeleaf.spring6.web.webflux.ISpringWebFluxWebSession;
import org.thymeleaf.spring6.web.webflux.SpringWebFluxWebApplication;
import org.thymeleaf.spring6.web.webflux.SpringWebFluxWebRequest;
import org.thymeleaf.spring6.web.webflux.SpringWebFluxWebSession;
import org.thymeleaf.util.Validate;

final class SpringWebFluxWebExchange
implements ISpringWebFluxWebExchange {
    private final SpringWebFluxWebRequest webRequest;
    private final SpringWebFluxWebApplication webApplication;
    private SpringWebFluxWebSession webSession;
    private boolean webSessionInitialized;
    private final ServerWebExchange exchange;
    private final Locale locale;
    private final MediaType mediaType;
    private final Charset charset;

    SpringWebFluxWebExchange(SpringWebFluxWebRequest webRequest, SpringWebFluxWebApplication webApplication, ServerWebExchange exchange, Locale locale, MediaType mediaType, Charset charset) {
        Validate.notNull((Object)webRequest, (String)"Request cannot be null");
        Validate.notNull((Object)webApplication, (String)"Application cannot be null");
        Validate.notNull((Object)exchange, (String)"Server Web Exchange cannot be null");
        Validate.notNull((Object)locale, (String)"Locale cannot be null");
        Validate.notNull((Object)mediaType, (String)"Media Type cannot be null");
        Validate.notNull((Object)charset, (String)"Charset cannot be null");
        this.webRequest = webRequest;
        this.webApplication = webApplication;
        this.exchange = exchange;
        this.locale = locale;
        this.mediaType = mediaType;
        this.charset = charset;
        this.webSession = null;
        this.webSessionInitialized = false;
    }

    @Override
    public ISpringWebFluxWebRequest getRequest() {
        return this.webRequest;
    }

    @Override
    public ISpringWebFluxWebSession getSession() {
        WebSession session;
        if (!this.webSessionInitialized && (session = (WebSession)this.exchange.getAttribute("thymeleafWebSession")) != null) {
            this.webSession = new SpringWebFluxWebSession(session);
            this.webSessionInitialized = true;
        }
        return this.webSession;
    }

    @Override
    public ISpringWebFluxWebApplication getApplication() {
        return this.webApplication;
    }

    public Principal getPrincipal() {
        return (Principal)this.exchange.getAttribute("thymeleafWebExchangePrincipal");
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getContentType() {
        return this.mediaType.toString();
    }

    public String getCharacterEncoding() {
        return this.charset.name();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.exchange.getAttributes());
    }

    @Override
    public Object getAttributeValue(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        return this.exchange.getAttribute(name);
    }

    public void setAttributeValue(String name, Object value) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        if (value == null) {
            this.exchange.getAttributes().remove(name);
        } else {
            this.exchange.getAttributes().put(name, value);
        }
    }

    public void removeAttribute(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        this.exchange.getAttributes().remove(name);
    }

    @Override
    public Object getNativeExchangeObject() {
        return this.exchange;
    }

    public String transformURL(String url) {
        return this.exchange.transformUrl(url);
    }
}

